package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskUserHoliday;
import com.github.yulichang.base.MPJBaseService;
import org.apache.ibatis.annotations.Param;

/**
 * 现状风险巡查用户请假Service接口
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
public interface ICurrentRiskUserHolidayService  extends MPJBaseService<CurrentRiskUserHoliday>
{
    /**
     * 查询现状风险巡查用户请假
     * 
     * @param id 现状风险巡查用户请假主键
     * @return 现状风险巡查用户请假
     */
    public CurrentRiskUserHoliday selectCurrentRiskUserHolidayById(Long id);

    /**
     * 查询现状风险巡查用户请假列表
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 现状风险巡查用户请假集合
     */
    public List<CurrentRiskUserHoliday> selectCurrentRiskUserHolidayList(CurrentRiskUserHoliday currentRiskUserHoliday);

    /**
     * 新增现状风险巡查用户请假
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 结果
     */
    public int insertCurrentRiskUserHoliday(CurrentRiskUserHoliday currentRiskUserHoliday);

    /**
     * 修改现状风险巡查用户请假
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 结果
     */
    public int updateCurrentRiskUserHoliday(CurrentRiskUserHoliday currentRiskUserHoliday);

    /**
     * 批量删除现状风险巡查用户请假
     * 
     * @param ids 需要删除的现状风险巡查用户请假主键集合
     * @return 结果
     */
    public int deleteCurrentRiskUserHolidayByIds(Long[] ids);

    /**
     * 删除现状风险巡查用户请假信息
     * 
     * @param id 现状风险巡查用户请假主键
     * @return 结果
     */
    public int deleteCurrentRiskUserHolidayById(Long id);

    List<Long> memberUserIds(@Param("userId") Long userId);
}
