package com.ruoyi.system.mapper;

import java.util.List;
import java.util.Map;

import com.ruoyi.system.domain.BacklogInfo;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;

/**
 * 待办信息Mapper接口
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
public interface BacklogInfoMapper  extends MPJBaseMapper<BacklogInfo>
{
    /**
     * 查询待办信息
     * 
     * @param id 待办信息主键
     * @return 待办信息
     */
    public BacklogInfo selectBacklogInfoById(String id);

    /**
     * 查询待办信息列表
     * 
     * @param backlogInfo 待办信息
     * @return 待办信息集合
     */
    public List<BacklogInfo> selectBacklogInfoList(BacklogInfo backlogInfo);


    /**
     * 查询待办未读信息数量
     */
    public int selectUnReadCount(@Param("loginName") String loginName, @Param("app_url") String app_url, @Param("menu_url") String menu_url);
    /**
     * 清除未读
     */
    public boolean updateChangeStatus(String loginName);

    Map<String, Integer> getStatusCount(@Param("loginName") String loginName, @Param("beginTime") String beginTime
            , @Param("endTime") String endTime, @Param("keyword") String keyword);

    int updateBacklogInfoByPid(BacklogInfo backlogInfo);

    /**
     * 新增待办信息
     * 
     * @param backlogInfo 待办信息
     * @return 结果
     */
    public int insertBacklogInfo(BacklogInfo backlogInfo);

    /**
     * 修改待办信息
     * 
     * @param backlogInfo 待办信息
     * @return 结果
     */
    public int updateBacklogInfo(BacklogInfo backlogInfo);

    /**
     * 删除待办信息
     * 
     * @param id 待办信息主键
     * @return 结果
     */
    public int deleteBacklogInfoById(String id);

    /**
     * 批量删除待办信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteBacklogInfoByIds(String[] ids);
}
