package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 消息信息对象 message_info
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
@Data
public class MessageInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 消息信息ID */
    private String id;

    /** 节点ID */
    @Excel(name = "节点ID")
    private String nodeId;

    /** 流程事项ID */
    @Excel(name = "流程事项ID")
    private String pid;

    /** 信息标题 */
    @Excel(name = "信息标题")
    private String title;

    /** 信息内容详情 */
    @Excel(name = "信息内容详情")
    private String content;

    /** 消息已读状态（0：未读、1：已读） */
    @Excel(name = "消息已读状态", readConverterExp = "0=：未读、1：已读")
    private String status;

    /** 消息通知人 */
    @Excel(name = "消息通知人")
    private String messageBy;

    /** app菜单名称 */
    @Excel(name = "app菜单名称")
    private String menuName;

    /** pc菜单路由 */
    @Excel(name = "pc菜单路由")
    private String menuUrl;

    /** app路由 */
    @Excel(name = "app路由")
    private String appUrl;


    /**
     * 开始时间
     */
    @Excel(name = "开始时间")
    @TableField(exist = false)
    private String beginTime;

    /**
     * 结束时间
     */
    @Excel(name = "结束时间")
    @TableField(exist = false)
    private String endTime;

}
