package com.ruoyi.system.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 待办信息对象 backlog_info
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
@Data
public class BacklogInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 流程事项ID */
    private String id;

    /** 节点ID */
    @Excel(name = "节点ID")
    private String nodeId;

    /** 流程ID */
    @Excel(name = "流程ID")
    private String pid;

    /** 主表id（app） */
    @Excel(name = "主表id", readConverterExp = "a=pp")
    private String mainId;

    /** 标题 */
    @Excel(name = "标题")
    private String title;

    /** 主题 */
    @Excel(name = "主题")
    private String theme;

    /** 内容详情 */
    @Excel(name = "内容详情")
    private String content;

    /** 办理状态（0：待办，1：已办） */
    @Excel(name = "办理状态", readConverterExp = "0=：待办，1：已办")
    private String status;

    /** 待办人 */
    @Excel(name = "待办人")
    private String backlogBy;

    /** app路由名称 */
    @Excel(name = "app路由名称")
    private String menuName;

    /** pc路由地址 */
    @Excel(name = "pc路由地址")
    private String menuUrl;

    /** app路由地址 */
    @Excel(name = "app路由地址")
    private String appUrl;

    /**
     * 开始时间
     */
    @Excel(name = "开始时间")
    @TableField(exist = false)
    private String beginTime;

    /**
     * 结束时间
     */
    @Excel(name = "结束时间")
    @TableField(exist = false)
    private String endTime;

}
