package com.ruoyi.system.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.utils.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.system.domain.MessageInfo;
import com.ruoyi.system.service.IMessageInfoService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 消息信息Controller
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
@RestController
@RequestMapping(value = {"/system/messageInfo","/app-api/messageInfo"})
public class MessageInfoController extends BaseController
{
    @Autowired
    private IMessageInfoService messageInfoService;

    /**
     * 查询消息信息列表
     */
//    @RequiresPermissions("system:messageInfo:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(MessageInfo messageInfo) {
        startPage();
        String loginName = getUsername();
        if (StringUtils.isNotNull(messageInfo.getParams().get("beginTime")) && !"".equals(messageInfo.getParams().get("beginTime"))) {
            String beginTime = messageInfo.getParams().get("beginTime") + " 00:00:00";
            messageInfo.setBeginTime(beginTime);
        }
        if (StringUtils.isNotNull(messageInfo.getParams().get("endTime")) && !"".equals(messageInfo.getParams().get("endTime"))) {
            String endTime = messageInfo.getParams().get("endTime") + " 59:59:59";
            messageInfo.setEndTime(endTime);
        }
        messageInfo.setMessageBy(loginName);
        List<MessageInfo> list = messageInfoService.selectMessageInfoList(messageInfo);
        for (MessageInfo info : list) {
            String createBy = info.getCreateBy() == null ? "系统" : info.getCreateBy();
            info.setCreateBy(createBy);
        }
        return getDataTable(list);
    }


    /**
     * 导出消息信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:messageInfo:export')")
    @Log(title = "消息信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, MessageInfo messageInfo)
    {
        List<MessageInfo> list = messageInfoService.selectMessageInfoList(messageInfo);
        ExcelUtil<MessageInfo> util = new ExcelUtil<MessageInfo>(MessageInfo.class);
        util.exportExcel(response, list, "消息信息数据");
    }

    /**
     * 获取消息信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:messageInfo:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return success(messageInfoService.selectMessageInfoById(id));
    }

    /**
     * 新增消息信息
     */
    @PreAuthorize("@ss.hasPermi('system:messageInfo:add')")
    @Log(title = "消息信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MessageInfo messageInfo)
    {
        return toAjax(messageInfoService.insertMessageInfo(messageInfo));
    }

    /**
     * 修改消息信息
     */
    @PreAuthorize("@ss.hasPermi('system:messageInfo:edit')")
    @Log(title = "消息信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MessageInfo messageInfo)
    {
        return toAjax(messageInfoService.updateMessageInfo(messageInfo));
    }

    /**
     * 删除消息信息
     */
    @PreAuthorize("@ss.hasPermi('system:messageInfo:remove')")
    @Log(title = "消息信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(messageInfoService.deleteMessageInfoByIds(ids));
    }

    /**
     * 未读改为已读
     */
//    @Log(title = "消息信息", businessType = BusinessType.UPDATE)
    @PostMapping("/changeRead")
    @ResponseBody
    @Transactional
    public AjaxResult changeRead(MessageInfo messageInfo) {
        messageInfo.setStatus("1");
        return toAjax(messageInfoService.updateMessageInfo(messageInfo));
    }
}
