package com.censoft.censoftrongtong.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolDetail;
import com.censoft.censoftrongtong.enums.CycleType;
import com.censoft.censoftrongtong.service.*;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@AllArgsConstructor
@Component("currentRiskTask")
public class CurrentRiskTask {

    private ICurrentRiskPostListService currentRiskPostListService;
    private ICurrentRiskUserPatrolService currentRiskUserPatrolService;
    private ICurrentRiskUserPatrolDetailService currentRiskUserPatrolDetailService;

    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");

    /**
     * 每天零点发送任务
     * @param isDailypOther 除每月 1 号外，是否新增日查之外的巡查 默认不新增
     */
    private void senTask(boolean isDailypOther){
        //判断是否查询当天巡查任务是否发放
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(Calendar.HOUR_OF_DAY);
        int day = calendar.get(Calendar.DAY_OF_MONTH);
        //查询所有的任务列表
        QueryWrapper<CurrentRiskPostList> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status","0");
        List<CurrentRiskPostList> currentRiskPostLists = currentRiskPostListService.list();
        if(CollectionUtils.isEmpty(currentRiskPostLists)){
            return;
        }
        //查询所有人的巡查类型，按巡查类型分类
        List<CurrentRiskPostList> patrolTypeList = currentRiskPostListService.selectCurrentRiskPostListList3();
        for (CurrentRiskPostList patrolType : patrolTypeList){
            //初始化用户巡查总表
            CurrentRiskUserPatrol currentRiskUserPatrol = new CurrentRiskUserPatrol();
            //开始时间，结束时间
            try {
                initTime(currentRiskUserPatrol,patrolType.getPatrolType());
            } catch (Exception e) {
                e.printStackTrace();
                log.info("初始化时间出错");
            }
            //查询当天巡查任务是否发放
            //查询是否发送过
            QueryWrapper<CurrentRiskUserPatrol> patrolQueryWrapper = new QueryWrapper<>();
            patrolQueryWrapper.eq("user_id",patrolType.getUserId()).eq("risk_post_id", patrolType.getPostId())
                    .eq("patrol_type",patrolType.getPatrolType())
                    .ge("start_time",currentRiskUserPatrol.getStartTime()).le("start_time",currentRiskUserPatrol.getEndTime());
            //如果是日查 且 属于主动点击行为，则进行校验
            if(hour > 2 && patrolType.getPatrolType().equals(CycleType.DAILY.getValue())){
                if(currentRiskUserPatrolService.count(patrolQueryWrapper) > 0){
                    continue;
                }
            }
            // 大于1号 且 非日查 要添加 计划查询的数据要进行测验
            if(day > 1 && isDailypOther && !patrolType.getPatrolType().equals(CycleType.DAILY.getValue())){
                if(currentRiskUserPatrolService.count(patrolQueryWrapper) > 0){
                    continue;
                }
            }
            //新增任务
            List<CurrentRiskPostList> saveCurrentRiskPostLists =  currentRiskPostLists.stream().
                    filter(currentRiskPostList -> currentRiskPostList.getPostId().equals(patrolType.getPostId())
                            && currentRiskPostList.getPatrolType().equals(patrolType.getPatrolType())
                        && currentRiskPostList.getUserId().equals(patrolType.getUserId())).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(saveCurrentRiskPostLists)){
                continue;
            }
            currentRiskPostLists.removeAll(saveCurrentRiskPostLists);
            //新增用户巡查总表
            currentRiskUserPatrol.setUserId(patrolType.getUserId());
            currentRiskUserPatrol.setProjectId(patrolType.getProjectId());
            currentRiskUserPatrol.setRiskPostId(patrolType.getPostId());
            //状态 0 未巡查 1 已巡查 2 已请假 3 已过期
            currentRiskUserPatrol.setPatrolType(Integer.valueOf(patrolType.getPatrolType()));
            currentRiskUserPatrol.setStatus("0");
            currentRiskUserPatrol.setCreateTime(new Date());
            currentRiskUserPatrolService.insertCurrentRiskUserPatrol(currentRiskUserPatrol);
            //新增巡查明细信息
            List<CurrentRiskUserPatrolDetail> list = new ArrayList<>();
            saveCurrentRiskPostLists.forEach(saveCurrentRiskPostList ->{
                CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail = new CurrentRiskUserPatrolDetail();
                currentRiskUserPatrolDetail.setCurrentRiskId(saveCurrentRiskPostList.getCurrentRiskId());
                currentRiskUserPatrolDetail.setPatrolId(currentRiskUserPatrol.getId());
                //状态 0 正常 1 异常
                currentRiskUserPatrolDetail.setStatus("0");
                currentRiskUserPatrolDetail.setCreateTime(new Date());
                list.add(currentRiskUserPatrolDetail);
            });
            currentRiskUserPatrolDetailService.saveBatch(list);
        }
    }

    /**
     * 开始时间，结束时间计算
     * @param currentRiskUserPatrol 对象
     * @param patrolType 巡检类型 0 日查 1 周查 2 月查 3 季查 4 年查
     */
    private void initTime(CurrentRiskUserPatrol currentRiskUserPatrol,String patrolType)throws Exception{
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(Calendar.YEAR);
        int currentMonth = calendar.get(Calendar.MONTH) + 1;
        String startTime = "";
        String endTime = "";
        //日查
        if(patrolType.equals(CycleType.DAILY.getValue())){
            startTime = SDF.format(calendar.getTime()) + " 00:00:00";
            endTime = SDF.format(calendar.getTime()) + " 23:59:59";
        }
        //周查
        if(patrolType.equals(CycleType.WEEKLY.getValue())){
            // 获取当前是周几，注意返回值是1-7，1表示周日，2表示周一，以此类推
            int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
            if(dayOfWeek == 1 ){
                calendar.add(Calendar.DATE, -6);
            }else{
                calendar.add(Calendar.DATE, 2-dayOfWeek);
            }
            startTime = SDF.format(calendar.getTime()) + " 00:00:00";
            calendar.add(Calendar.DATE, 6);
            endTime = SDF.format(calendar.getTime()) + " 23:59:59";
        }
        //月查
        if(patrolType.equals(CycleType.MONTH.getValue())){
            startTime = currentYear + "-" + currentMonth + "-01 00:00:00";
            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
            int lastDayOfMonth = calendar.get(Calendar.DAY_OF_MONTH);
            endTime = currentYear + "-" + currentMonth + "-" + lastDayOfMonth +" 23:59:59";
        }
        //季查
        if(patrolType.equals(CycleType.QUARTERLY.getValue())){
            // 获取当前月份，注意返回值是0-11，因此需要加1
            int month = calendar.get(Calendar.MONTH) + 1;
            // 获取当前季度，注意返回值是1-4，1表示第一季度，以此类推
            int quarter = (month - 1) / 3 + 1;
            //季度初始月份
            int quarterMonth =  1 + (3 * (quarter-1));
            startTime = currentYear + "-"+quarterMonth + "-01 00:00:00";
            calendar.setTime(SDF.parse(startTime));
            calendar.add(Calendar.MONTH,2);
            calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
            int lastDayOfMonth = calendar.get(Calendar.DAY_OF_MONTH);
            endTime = currentYear + "-" + currentMonth + "-" + lastDayOfMonth +" 23:59:59";
        }
        //年查
        if(patrolType.equals(CycleType.YEARLY.getValue())){
            startTime = currentYear + "-01-01 00:00:00";
            endTime = currentYear + "-12-31 23:59:59";
        }
        try {
            currentRiskUserPatrol.setStartTime(simpleDateFormat.parse(startTime));
            currentRiskUserPatrol.setEndTime(simpleDateFormat.parse(endTime));
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }
}
