package com.censoft.censoftrongtong.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 风险计划对象 risk_plan
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public class RiskPlan extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String name;

    /** 任务编号 */
    @Excel(name = "任务编号")
    private String no;

    /** 项目id */
    @Excel(name = "项目id")
    private Long projectId;

    /** 楼栋ids */
    @Excel(name = "楼栋ids")
    private String buildingIds;

    /** 创建人员id */
    @Excel(name = "创建人员id")
    private Long createUserId;

    /** 创建单位 */
    @Excel(name = "创建单位")
    private Long createDeptId;

    /** 负责人id */
    @Excel(name = "负责人id")
    private Long leaderUserId;

    /** 执行人员ids */
    @Excel(name = "执行人员ids")
    private String workUserIds;

    /** 审批人id */
    @Excel(name = "审批人id")
    private Long approveUserId;

    /** 开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 状态 */
    @Excel(name = "状态")
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setNo(String no) 
    {
        this.no = no;
    }

    public String getNo() 
    {
        return no;
    }
    public void setProjectId(Long projectId) 
    {
        this.projectId = projectId;
    }

    public Long getProjectId() 
    {
        return projectId;
    }
    public void setBuildingIds(String buildingIds) 
    {
        this.buildingIds = buildingIds;
    }

    public String getBuildingIds() 
    {
        return buildingIds;
    }
    public void setCreateUserId(Long createUserId) 
    {
        this.createUserId = createUserId;
    }

    public Long getCreateUserId() 
    {
        return createUserId;
    }
    public void setCreateDeptId(Long createDeptId) 
    {
        this.createDeptId = createDeptId;
    }

    public Long getCreateDeptId() 
    {
        return createDeptId;
    }
    public void setLeaderUserId(Long leaderUserId) 
    {
        this.leaderUserId = leaderUserId;
    }

    public Long getLeaderUserId() 
    {
        return leaderUserId;
    }
    public void setWorkUserIds(String workUserIds) 
    {
        this.workUserIds = workUserIds;
    }

    public String getWorkUserIds() 
    {
        return workUserIds;
    }
    public void setStartTime(Date startTime) 
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    public Long getApproveUserId() {
        return approveUserId;
    }

    public void setApproveUserId(Long approveUserId) {
        this.approveUserId = approveUserId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("name", getName())
            .append("no", getNo())
            .append("projectId", getProjectId())
            .append("buildingIds", getBuildingIds())
            .append("createUserId", getCreateUserId())
            .append("createDeptId", getCreateDeptId())
            .append("leaderUserId", getLeaderUserId())
            .append("workUserIds", getWorkUserIds())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("status", getStatus())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
