package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 基础数据-项目对象 ledger_project
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerProject extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 项目名称 */
    @Excel(name = "项目名称")
    private String name;

    /** 项目类型 */
    @Excel(name = "项目类型")
    private String type;

    /** 项目业态 */
    @Excel(name = "项目业态")
    private String business;

    /** 组织机构id */
    @Excel(name = "组织机构id")
    private Long deptId;

    /** 所在城市 */
    @Excel(name = "所在城市")
    private String city;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String address;

    /** 0-关联 1-自建 */
    @Excel(name = "0-关联 1-自建")
    private String source;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;
    /**
     * 部门名称名称
     */
    @TableField(exist = false)
    private String deptName;

    /**
     * 数量
     */
    @TableField(exist = false)
    private String num;




}
