package com.ruoyi.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.system.mapper.WebsitesMapper;
import com.ruoyi.system.domain.Websites;
import com.ruoyi.system.service.IWebsitesService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
/**
 * 网站管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-27
 */
@Service
public class WebsitesServiceImpl extends ServiceImpl<WebsitesMapper, Websites> implements IWebsitesService
{
    @Autowired
    private WebsitesMapper websitesMapper;

    /**
     * 查询网站管理
     * 
     * @param id 网站管理主键
     * @return 网站管理
     */
    @Override
    public Websites selectWebsitesById(Long id)
    {
        return websitesMapper.selectWebsitesById(id);
    }

    /**
     * 查询网站管理列表
     * 
     * @param websites 网站管理
     * @return 网站管理
     */
    @Override
    public List<Websites> selectWebsitesList(Websites websites)
    {
        return websitesMapper.selectWebsitesList(websites);
    }

    /**
     * 新增网站管理
     * 
     * @param websites 网站管理
     * @return 结果
     */
    @Override
    public int insertWebsites(Websites websites)
    {
        return websitesMapper.insertWebsites(websites);
    }

    /**
     * 修改网站管理
     * 
     * @param websites 网站管理
     * @return 结果
     */
    @Override
    public int updateWebsites(Websites websites)
    {
        return websitesMapper.updateWebsites(websites);
    }

    /**
     * 批量删除网站管理
     * 
     * @param ids 需要删除的网站管理主键
     * @return 结果
     */
    @Override
    public int deleteWebsitesByIds(Long[] ids)
    {
        return websitesMapper.deleteWebsitesByIds(ids);
    }

    /**
     * 删除网站管理信息
     * 
     * @param id 网站管理主键
     * @return 结果
     */
    @Override
    public int deleteWebsitesById(Long id)
    {
        return websitesMapper.deleteWebsitesById(id);
    }
}
