package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskUserPatrolDetailMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolDetail;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolDetailService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 现状风险用户巡查明细Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@Service
public class CurrentRiskUserPatrolDetailServiceImpl extends MPJBaseServiceImpl<CurrentRiskUserPatrolDetailMapper, CurrentRiskUserPatrolDetail> implements ICurrentRiskUserPatrolDetailService
{
    @Autowired
    private CurrentRiskUserPatrolDetailMapper currentRiskUserPatrolDetailMapper;

    /**
     * 查询现状风险用户巡查明细
     * 
     * @param id 现状风险用户巡查明细主键
     * @return 现状风险用户巡查明细
     */
    @Override
    public CurrentRiskUserPatrolDetail selectCurrentRiskUserPatrolDetailById(Long id)
    {
        return currentRiskUserPatrolDetailMapper.selectCurrentRiskUserPatrolDetailById(id);
    }

    /**
     * 查询现状风险用户巡查明细列表
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 现状风险用户巡查明细
     */
    @Override
    public List<CurrentRiskUserPatrolDetail> selectCurrentRiskUserPatrolDetailList(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        return currentRiskUserPatrolDetailMapper.selectCurrentRiskUserPatrolDetailList(currentRiskUserPatrolDetail);
    }

    /**
     * 新增现状风险用户巡查明细
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 结果
     */
    @Override
    public int insertCurrentRiskUserPatrolDetail(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        currentRiskUserPatrolDetail.setCreateTime(DateUtils.getNowDate());
        return currentRiskUserPatrolDetailMapper.insertCurrentRiskUserPatrolDetail(currentRiskUserPatrolDetail);
    }

    /**
     * 修改现状风险用户巡查明细
     * 
     * @param currentRiskUserPatrolDetail 现状风险用户巡查明细
     * @return 结果
     */
    @Override
    public int updateCurrentRiskUserPatrolDetail(CurrentRiskUserPatrolDetail currentRiskUserPatrolDetail)
    {
        currentRiskUserPatrolDetail.setUpdateTime(DateUtils.getNowDate());
        return currentRiskUserPatrolDetailMapper.updateCurrentRiskUserPatrolDetail(currentRiskUserPatrolDetail);
    }

    /**
     * 批量删除现状风险用户巡查明细
     * 
     * @param ids 需要删除的现状风险用户巡查明细主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserPatrolDetailByIds(Long[] ids)
    {
        return currentRiskUserPatrolDetailMapper.deleteCurrentRiskUserPatrolDetailByIds(ids);
    }

    /**
     * 删除现状风险用户巡查明细信息
     * 
     * @param id 现状风险用户巡查明细主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserPatrolDetailById(Long id)
    {
        return currentRiskUserPatrolDetailMapper.deleteCurrentRiskUserPatrolDetailById(id);
    }
}
