package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.github.yulichang.base.MPJBaseService;
/**
 * 现状风险岗位用户巡查清单Service接口
 * 
 * @author bobbao
 * @date 2023-12-07
 */
public interface ICurrentRiskPostListService  extends MPJBaseService<CurrentRiskPostList>
{
    /**
     * 查询现状风险岗位用户巡查清单
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 现状风险岗位用户巡查清单
     */
    public CurrentRiskPostList selectCurrentRiskPostListById(Long id);

    /**
     * 查询现状风险岗位用户巡查清单列表
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 现状风险岗位用户巡查清单集合
     */
    public List<CurrentRiskPostList> selectCurrentRiskPostListList(CurrentRiskPostList currentRiskPostList);

    /**
     * 新增现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    public int insertCurrentRiskPostList(CurrentRiskPostList currentRiskPostList);

    /**
     * 修改现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    public int updateCurrentRiskPostList(CurrentRiskPostList currentRiskPostList);

    /**
     * 批量删除现状风险岗位用户巡查清单
     * 
     * @param ids 需要删除的现状风险岗位用户巡查清单主键集合
     * @return 结果
     */
    public int deleteCurrentRiskPostListByIds(Long[] ids);

    /**
     * 删除现状风险岗位用户巡查清单信息
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 结果
     */
    public int deleteCurrentRiskPostListById(Long id);
}
