package com.censoft.censoftrongtong.mapper;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.github.yulichang.base.MPJBaseMapper;

/**
 * 现状风险岗位用户巡查清单Mapper接口
 * 
 * @author bobbao
 * @date 2023-12-07
 */
public interface CurrentRiskPostListMapper  extends MPJBaseMapper<CurrentRiskPostList>
{
    /**
     * 查询现状风险岗位用户巡查清单
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 现状风险岗位用户巡查清单
     */
    public CurrentRiskPostList selectCurrentRiskPostListById(Long id);

    /**
     * 查询现状风险岗位用户巡查清单列表
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 现状风险岗位用户巡查清单集合
     */
    public List<CurrentRiskPostList> selectCurrentRiskPostListList(CurrentRiskPostList currentRiskPostList);

    /**
     * 新增现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    public int insertCurrentRiskPostList(CurrentRiskPostList currentRiskPostList);

    /**
     * 修改现状风险岗位用户巡查清单
     * 
     * @param currentRiskPostList 现状风险岗位用户巡查清单
     * @return 结果
     */
    public int updateCurrentRiskPostList(CurrentRiskPostList currentRiskPostList);

    /**
     * 删除现状风险岗位用户巡查清单
     * 
     * @param id 现状风险岗位用户巡查清单主键
     * @return 结果
     */
    public int deleteCurrentRiskPostListById(Long id);

    /**
     * 批量删除现状风险岗位用户巡查清单
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCurrentRiskPostListByIds(Long[] ids);
}
