package com.ruoyi.common.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.Map;
import java.util.UUID;

/**
 * @created: 2020/10/16 16:49
 * @author: winston
 * @description: 导出Word工具类
 */
@Component
public class WordUtil {
    @Autowired
    private static Logger logger = LogManager.getLogger(WordUtil.class);
    /**
     * 模板路径
     */
    private static final String FTL_FP = "/templates/ftl/";

    private static Configuration configuration = null;
    static {
        configuration = new Configuration();
        //设置默认的编码
        configuration.setDefaultEncoding("utf-8");
    }

    /**
     * @param dataMap 数据库数据
     * @param ftl     替换的模板
     * @return
     * @throws IOException
     */
    public static String createDoc(Map dataMap, String ftl) throws IOException {

        configuration.setClassForTemplateLoading(WordUtil.class, FTL_FP);
        String path = (String) dataMap.get("path");
        Template template = null;
        try {
            // yxkj.ftl为要装载的模板
            template = configuration.getTemplate(ftl);
            template.setEncoding("utf-8");
        } catch (IOException e) {
            e.printStackTrace();
        }

        // 输出文档路径及名称
        String fileName = dataMap.get("title") + ".doc";

        File outFile = new File(path + fileName);
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile), "utf-8"));
        } catch (Exception e1) {
            logger.error(e1);
            fileName = "";
        }
        try {
            template.process(dataMap, out);
            out.close();
        } catch (TemplateException e2) {
            logger.error(e2);
            fileName = "";
        } catch (IOException e) {
            logger.error(e);
            fileName = "";
        }
        return fileName;
    }

    /**
     * 通用文件下载方法
     *
     * @param response
     * @param filePath 文件绝对路径
     *                 this.getClass().getClassLoader().getResource("file").getPath
     *                 ();
     * @param fileName 文件名
     * @throws IOException
     */
    public static void responseDownloadFile(HttpServletRequest request, HttpServletResponse response, String filePath, String fileName) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/msword");
        // 设置浏览器以下载的方式处理该文件名
        response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(fileName, "UTF-8"))));

        File file = new File(filePath + "/" + fileName );
        try (InputStream fin = new FileInputStream(file);
             ServletOutputStream out = response.getOutputStream()) {
            // 缓冲区
            byte[] buffer = new byte[512];
            int bytesToRead;
            // 通过循环将读入的Word文件的内容输出到浏览器中
            while ((bytesToRead = fin.read(buffer)) != -1) {
                out.write(buffer, 0, bytesToRead);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            // 删除临时文件
            file.delete();
        }
    }


    public static String getImageStr(String imgFile) {
        InputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFile);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            data = new byte[in.available()];
            //注：FileInputStream.available()方法可以从输入流中阻断由下一个方法调用这个输入流中读取的剩余字节数
            in.read(data);
            in.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);

    }

    public static void main(String[] args) {
        System.out.println(getImageStr("C:/aqpt/uploadPath/upload/signature/20220114095137.png"));
    }
}
