package com.censoft.censoftrongtong.domain.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

/**
 * 固有风险清单库对象 risk_inherent_list
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class RiskInherentListSaveDto {

    /**
     * id
     */
    private Long id;

    /**
     * 评估人id
     */
    private Long userId;

    /**
     * 房间id
     */
    private Long roomId;

    /**
     * 计划id
     */
    private Long planId;

    /**
     * 风险源名称
     */
    private String name;

    /**
     * 风险点类型
     */
    private String pointType;

    /**
     * 是否为特种设备
     */
    private Boolean specialEquipment;

    /**
     * 安全警示标志
     */
    private String safetyWarningSigns;

    /**
     * 风险因素
     */
    private String factor;

    /**
     * 准事故类型
     */
    private String type;

    /**
     * 风险等级
     */
    private String level;

    /**
     * 风险可能性
     */
    private String riskLikelihood;

    /**
     * 后果严重性
     */
    private String riskSeverity;

    /**
     * 存在部位
     */
    private String presenceLocation;

    /**
     * 风险源照片id
     */
    private String pictureFileIds;

    /**
     * 工程技术措施
     */
    private String measuresProject;

    /**
     * 工程技术措施附件
     */
    private String measuresProjectFileIds;

    /**
     * 应采取的管理措施
     */
    private String measuresAdministration;

    /**
     * 管控责任单位
     */
    private String measuresDeptName;

    /**
     * 管控责任人
     */
    private String measuresUserName;

    /**
     * 管控责任人联系方式
     */
    private String measuresUserPhone;

    /**
     * 已采取的管理措施
     */
    private String measuresAdministrationFileIds;

    /**
     * 危险源名称
     */
    private String hazardSourceName;

    /**
     * 是否存在重大危险源
     */
    private Boolean majorHazardSource;

    /**
     * 重大危险源描述
     */
    private String majorHazardSourceDescription;

    /**
     * 应急措施
     */
    private String measuresEmergency;

    /**
     * 应急处置措施附件
     */
    private String measuresEmergencyFileIds;

    /**
     * 参考依据
     */
    private String referenceBasis;
}
