package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险矩阵横纵坐标分值表 risk_assessment_matrix_score
 *
 * @author ruoyi
 * @date 2023-07-05
 */
@Data
@TableName("risk_assessment_matrix_score")
public class RiskAssessmentMatrixScore {

    /**
     * 名称
     */
    @TableId(type = IdType.INPUT,value = "title")
    private String title;

    /**
     * 横坐标还是纵坐标
     */
    @TableField("type")
    private String type;

    /**
     * 对应分值
     */
    @TableField("score")
    private BigDecimal score;

    /**
     * 排序
     */
    @TableField("sort")
    private Integer sort;
}
