package com.censoft.censoftrongtong.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 固有风险清单库Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskPlanInherentListMapper extends BaseMapper<RiskPlanInherentList>
{
    List<RiskPlanAppInherentListDto> getInherentListByPlanId(@Param("projectId") Long projectId, @Param("buildingId") Long buildingId, @Param("floorId") Long floorId, @Param("roomId") Long roomId);

    RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(@Param("inherentId") Long inherentId);

    List<RiskPlanAppExistingListDto> getExistingListByInherentId(@Param("inherentId") Long inherentId);
}
