package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.domain.EvaluationModelInfo;
import com.censoft.censoftrongtong.mapper.EvaluationModelInfoMapper;
import com.censoft.censoftrongtong.service.IEvaluationModelInfoService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

import static com.ruoyi.common.utils.SecurityUtils.getLoginUser;

/**
 * 评估模型信息Service业务层处理
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@Service
public class EvaluationModelInfoServiceImpl extends MPJBaseServiceImpl<EvaluationModelInfoMapper, EvaluationModelInfo> implements IEvaluationModelInfoService
{
    @Autowired
    private EvaluationModelInfoMapper evaluationModelInfoMapper;

    /**
     * 查询评估模型信息
     * 
     * @param id 评估模型信息主键
     * @return 评估模型信息
     */
    @Override
    public EvaluationModelInfo selectEvaluationModelInfoById(Long id)
    {
        return evaluationModelInfoMapper.selectEvaluationModelInfoById(id);
    }

    /**
     * 查询评估模型信息列表
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 评估模型信息
     */
    @Override
    public List<EvaluationModelInfo> selectEvaluationModelInfoList(EvaluationModelInfo evaluationModelInfo)
    {
        return evaluationModelInfoMapper.selectEvaluationModelInfoList(evaluationModelInfo);
    }

    /**
     * 新增评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    @Override
    public int insertEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo)
    {
        evaluationModelInfo.setCreateTime(DateUtils.getNowDate());
        evaluationModelInfo.setCreateBy(getLoginUser().getUserId()+"");
        return evaluationModelInfoMapper.insertEvaluationModelInfo(evaluationModelInfo);
    }

    /**
     * 修改评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    @Override
    public int updateEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo)
    {
        evaluationModelInfo.setUpdateTime(DateUtils.getNowDate());
        evaluationModelInfo.setCreateBy(getLoginUser().getUserId()+"");
        return evaluationModelInfoMapper.updateEvaluationModelInfo(evaluationModelInfo);
    }

    /**
     * 批量删除评估模型信息
     * 
     * @param ids 需要删除的评估模型信息主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationModelInfoByIds(Long[] ids)
    {
        return evaluationModelInfoMapper.deleteEvaluationModelInfoByIds(ids);
    }

    /**
     * 删除评估模型信息信息
     * 
     * @param id 评估模型信息主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationModelInfoById(Long id)
    {
        return evaluationModelInfoMapper.deleteEvaluationModelInfoById(id);
    }
}
