package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.EvaluationModelInfo;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;
/**
 * 评估模型信息Service接口
 * 
 * @author xjchen
 * @date 2023-08-08
 */
public interface IEvaluationModelInfoService  extends MPJBaseService<EvaluationModelInfo>
{
    /**
     * 查询评估模型信息
     * 
     * @param id 评估模型信息主键
     * @return 评估模型信息
     */
    public EvaluationModelInfo selectEvaluationModelInfoById(Long id);

    /**
     * 查询评估模型信息列表
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 评估模型信息集合
     */
    public List<EvaluationModelInfo> selectEvaluationModelInfoList(EvaluationModelInfo evaluationModelInfo);

    /**
     * 新增评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    public int insertEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo);

    /**
     * 修改评估模型信息
     * 
     * @param evaluationModelInfo 评估模型信息
     * @return 结果
     */
    public int updateEvaluationModelInfo(EvaluationModelInfo evaluationModelInfo);

    /**
     * 批量删除评估模型信息
     * 
     * @param ids 需要删除的评估模型信息主键集合
     * @return 结果
     */
    public int deleteEvaluationModelInfoByIds(Long[] ids);

    /**
     * 删除评估模型信息信息
     * 
     * @param id 评估模型信息主键
     * @return 结果
     */
    public int deleteEvaluationModelInfoById(Long id);
}
