package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.mapper.RiskPlanExistingListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 现有风险清单库Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanExistingListServiceImpl implements IRiskPlanExistingListService
{
    @Autowired
    private RiskPlanExistingListMapper riskPlanExistingListMapper;

    /**
     * 查询现有风险清单库
     * 
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    @Override
    public RiskPlanExistingList selectRiskPlanExistingListById(Long id)
    {
        return riskPlanExistingListMapper.selectRiskPlanExistingListById(id);
    }

    /**
     * 查询现有风险清单库列表
     * 
     * @param riskPlanExistingList 现有风险清单库
     * @return 现有风险清单库
     */
    @Override
    public List<RiskPlanExistingList> selectRiskPlanExistingListList(RiskPlanExistingList riskPlanExistingList)
    {
        return riskPlanExistingListMapper.selectRiskPlanExistingListList(riskPlanExistingList);
    }

    /**
     * 新增现有风险清单库
     * 
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList)
    {
        riskPlanExistingList.setCreateTime(DateUtils.getNowDate());
        return riskPlanExistingListMapper.insertRiskPlanExistingList(riskPlanExistingList);
    }

    /**
     * 修改现有风险清单库
     * 
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList)
    {
        riskPlanExistingList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanExistingListMapper.updateRiskPlanExistingList(riskPlanExistingList);
    }

    /**
     * 批量删除现有风险清单库
     * 
     * @param ids 需要删除的现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanExistingListByIds(Long[] ids)
    {
        return riskPlanExistingListMapper.deleteRiskPlanExistingListByIds(ids);
    }

    /**
     * 删除现有风险清单库信息
     * 
     * @param id 现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanExistingListById(Long id)
    {
        return riskPlanExistingListMapper.deleteRiskPlanExistingListById(id);
    }
}
