package com.censoft.censoftrongtong.domain;

import com.ruoyi.common.core.domain.BaseEntityClean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 项目用户岗位关系对象 project_user_post
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@Data
@ApiModel("项目用户岗位关系对象")
public class ProjectUserPost extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** 主键 id */
    @ApiModelProperty("项目 id")
    private Long id;

    /** 项目 id */
    @Excel(name = "项目 id")
    @ApiModelProperty("项目 id")
    private Long projectId;

    /** 用户 id */
    @Excel(name = "用户 id")
    @ApiModelProperty("用户 id")
    private Long userId;

    /** 岗位 id */
    @Excel(name = "岗位 id")
    @ApiModelProperty("岗位 id")
    private Long postId;
}
