package com.censoft.censoftrongtong.domain;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 基础数据-楼层对象 ledger_room
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
@TableName("ledger_room")
public class LedgerRoom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 楼层id */
    @Excel(name = "楼层id")
    @TableField("floor_id")
    private Long floorId;

    /** 房间名称 */
    @Excel(name = "房间名称")
    @TableField("name")
    private String name;

    /** 房间编号 */
    @Excel(name = "房间编号")
    @TableField("number")
    private String number;

    /** 房间面积 */
    @Excel(name = "房间面积")
    @TableField("area")
    private BigDecimal area;

    /** 房屋类型 */
    @Excel(name = "房屋类型")
    @TableField("room_type")
    private String roomType;

    /** 得分，积分 */
    @Excel(name = "得分，积分")
    @TableField("score")
    private String score;

    /** 楼层id */
    @Excel(name = "颜色")
    @TableField("color")
    private String color;

    /** 房屋平面图位置 */
    @Excel(name = "房屋平面图位置")
    @TableField("position")
    private String position;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    @TableField("status")
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    @TableField("del_flag")
    @TableLogic
    private String delFlag;
    /**
     * 楼层名称
     */
    @TableField(exist = false)
    private String floorName;

}
