package com.censoft.censoftrongtong.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.mapper.LedgerRoomMapper;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 基础数据-楼层Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerRoomServiceImpl extends MPJBaseServiceImpl<LedgerRoomMapper, LedgerRoom> implements ILedgerRoomService {

    @Resource
    private LedgerRoomMapper ledgerRoomMapper;

    @Override
    public List<LedgerRoom> getRoomListByBuildingId(Long floorId) {
        LambdaQueryWrapper<LedgerRoom> wrapper = new LambdaQueryWrapper<LedgerRoom>()
                .eq(LedgerRoom::getFloorId, floorId)
                .eq(LedgerRoom::getStatus, "0");
        return list(wrapper);
    }

    @Override
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom) {
        List<LedgerRoom> list = ledgerRoomMapper.selectLedgerRoomList(ledgerRoom);
        list.forEach(room->{
            room.setColor(getLevelColorByRoomId(room.getId()));
        });
        return list;
    }

    private String getLevelColorByRoomId(Long roomId) {
        String level = ledgerRoomMapper.getLevelColorByRoomId(roomId);
        if (StrUtil.isBlank(level)) {return "#F0F1F5";}
        switch (level){
            case "重大风险":
                return "#FF4433";
            case "较大风险":
                return "#FF9800";
            case "一般风险":
                return "#FFFF00";
            case "较小风险":
                return "#0091EA";
            default:
                return "#F0F1F5";
        }
    }
}
