package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LawList;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;

/**
 * 法律法规库Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILawListService extends MPJBaseService<LawList>
{
    /**
     * 查询法律法规库
     * 
     * @param id 法律法规库主键
     * @return 法律法规库
     */
    public LawList selectLawListById(Long id);

    /**
     * 查询法律法规库列表
     * 
     * @param lawList 法律法规库
     * @return 法律法规库集合
     */
    public List<LawList> selectLawListList(LawList lawList);

    /**
     * 新增法律法规库
     * 
     * @param lawList 法律法规库
     * @return 结果
     */
    public int insertLawList(LawList lawList);

    /**
     * 修改法律法规库
     * 
     * @param lawList 法律法规库
     * @return 结果
     */
    public int updateLawList(LawList lawList);

    /**
     * 批量删除法律法规库
     * 
     * @param ids 需要删除的法律法规库主键集合
     * @return 结果
     */
    public int deleteLawListByIds(Long[] ids);

    /**
     * 删除法律法规库信息
     * 
     * @param id 法律法规库主键
     * @return 结果
     */
    public int deleteLawListById(Long id);
}
