package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.mapper.LedgerRoomMapper;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 基础数据-楼层Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerRoomServiceImpl implements ILedgerRoomService
{
    @Autowired
    private LedgerRoomMapper ledgerRoomMapper;

    /**
     * 查询基础数据-楼层
     * 
     * @param id 基础数据-楼层主键
     * @return 基础数据-楼层
     */
    @Override
    public LedgerRoom selectLedgerRoomById(Long id)
    {
        return ledgerRoomMapper.selectLedgerRoomById(id);
    }

    /**
     * 查询基础数据-楼层列表
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 基础数据-楼层
     */
    @Override
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom)
    {
        return ledgerRoomMapper.selectLedgerRoomList(ledgerRoom);
    }

    /**
     * 新增基础数据-楼层
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 结果
     */
    @Override
    public int insertLedgerRoom(LedgerRoom ledgerRoom)
    {
        ledgerRoom.setCreateTime(DateUtils.getNowDate());
        return ledgerRoomMapper.insertLedgerRoom(ledgerRoom);
    }

    /**
     * 修改基础数据-楼层
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 结果
     */
    @Override
    public int updateLedgerRoom(LedgerRoom ledgerRoom)
    {
        ledgerRoom.setUpdateTime(DateUtils.getNowDate());
        return ledgerRoomMapper.updateLedgerRoom(ledgerRoom);
    }

    /**
     * 批量删除基础数据-楼层
     * 
     * @param ids 需要删除的基础数据-楼层主键
     * @return 结果
     */
    @Override
    public int deleteLedgerRoomByIds(Long[] ids)
    {
        return ledgerRoomMapper.deleteLedgerRoomByIds(ids);
    }

    /**
     * 删除基础数据-楼层信息
     * 
     * @param id 基础数据-楼层主键
     * @return 结果
     */
    @Override
    public int deleteLedgerRoomById(Long id)
    {
        return ledgerRoomMapper.deleteLedgerRoomById(id);
    }
}
