package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerBuilding;

import java.util.List;

/**
 * 基础数据-楼宇Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILedgerBuildingService 
{
    /**
     * 查询基础数据-楼宇
     * 
     * @param id 基础数据-楼宇主键
     * @return 基础数据-楼宇
     */
    public LedgerBuilding selectLedgerBuildingById(Long id);

    /**
     * 查询基础数据-楼宇列表
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 基础数据-楼宇集合
     */
    public List<LedgerBuilding> selectLedgerBuildingList(LedgerBuilding ledgerBuilding);

    /**
     * 新增基础数据-楼宇
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 结果
     */
    public int insertLedgerBuilding(LedgerBuilding ledgerBuilding);

    /**
     * 修改基础数据-楼宇
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 结果
     */
    public int updateLedgerBuilding(LedgerBuilding ledgerBuilding);

    /**
     * 批量删除基础数据-楼宇
     * 
     * @param ids 需要删除的基础数据-楼宇主键集合
     * @return 结果
     */
    public int deleteLedgerBuildingByIds(Long[] ids);

    /**
     * 删除基础数据-楼宇信息
     * 
     * @param id 基础数据-楼宇主键
     * @return 结果
     */
    public int deleteLedgerBuildingById(Long id);
}
