package com.censoft.censoftrongtong.enums;

/**
 * 巡查类型 0 日查 1 周查 2 月查 3 季查 4 年查
 */
public enum CycleType {
    //日查
    DAILY("0", "日查"),
    //周查
    WEEKLY("1", "周查"),
    //月查
    MONTH("2", "月查"),
    //季查
    QUARTERLY("3", "季查"),
    //年查
    YEARLY("4", "年查");

    private String value;
    private String name;

    CycleType(String value, String name) {
        this.value = value;
        this.name = name;
    }

    CycleType() {
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static CycleType getByValue(String value) {
        for (CycleType cycleType : values()) {
            if (cycleType.value.equals(value)) {
                return cycleType;
            }
        }
        return null;
    }
}
