package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppListDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 风险计划Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskPlanMapper 
{
    /**
     * 查询风险计划
     * 
     * @param id 风险计划主键
     * @return 风险计划
     */
    public RiskPlan selectRiskPlanById(Long id);

    /**
     * 查询风险计划列表
     * 
     * @param riskPlan 风险计划
     * @return 风险计划集合
     */
    public List<RiskPlan> selectRiskPlanList(RiskPlan riskPlan);

    /**
     * 新增风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int insertRiskPlan(RiskPlan riskPlan);

    /**
     * 修改风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int updateRiskPlan(RiskPlan riskPlan);

    /**
     * 删除风险计划
     * 
     * @param id 风险计划主键
     * @return 结果
     */
    public int deleteRiskPlanById(Long id);

    /**
     * 批量删除风险计划
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskPlanByIds(Long[] ids);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoList(@Param("statusStringList") List<String> statusStringList
            , @Param("createUserId") Long createUserId, @Param("leaderUserId") Long leaderUserId);
}
