package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.censoft.censoftrongtong.domain.LawList;
import com.censoft.censoftrongtong.domain.RiskSignRecord;
import com.censoft.censoftrongtong.mapper.LawListMapper;
import com.censoft.censoftrongtong.mapper.RiskSignRecordMapper;
import com.censoft.censoftrongtong.service.ILawListService;
import com.censoft.censoftrongtong.service.IRiskSignRecordService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 签到签退记录表Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskSignRecordServiceImpl
        extends MPJBaseServiceImpl<RiskSignRecordMapper, RiskSignRecord>
        implements IRiskSignRecordService {

    @Override
    public List<RiskSignRecord> getSignList(RiskSignRecord riskSignRecord) {
        LambdaQueryWrapper<RiskSignRecord> queryWrapper = new LambdaQueryWrapper<>();
        if (riskSignRecord.getType() != null) {
            queryWrapper = queryWrapper.eq(RiskSignRecord::getType,riskSignRecord.getType());
        }
        if (riskSignRecord.getUserId() != null) {
            queryWrapper = queryWrapper.eq(RiskSignRecord::getUserId,riskSignRecord.getUserId());
        }
        queryWrapper = queryWrapper.orderByAsc(RiskSignRecord::getCreateTime);
        return list(queryWrapper);
    }
}
