package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import io.swagger.annotations.Api;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.ProjectUserPost;
import com.censoft.censoftrongtong.service.IProjectUserPostService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 项目用户岗位关系Controller
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@RestController
@RequestMapping("/risk/currentProject")
public class ProjectUserPostController extends BaseController
{
    @Autowired
    private IProjectUserPostService projectUserPostService;

    /**
     * 查询项目用户岗位关系列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProjectUserPost projectUserPost)
    {
        projectUserPost.setUserId(getUserId());
        startPage();
        List<ProjectUserPost> list = projectUserPostService.selectProjectUserPostList(projectUserPost);
        return getDataTable(list);
    }

    /**
     * 导出项目用户岗位关系列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:export')")
    @Log(title = "项目用户岗位关系", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProjectUserPost projectUserPost)
    {
        List<ProjectUserPost> list = projectUserPostService.selectProjectUserPostList(projectUserPost);
        ExcelUtil<ProjectUserPost> util = new ExcelUtil<ProjectUserPost>(ProjectUserPost.class);
        util.exportExcel(response, list, "项目用户岗位关系数据");
    }

    /**
     * 获取项目用户岗位关系详细信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(projectUserPostService.selectProjectUserPostById(id));
    }

    /**
     * 新增项目用户岗位关系
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:add')")
    @Log(title = "项目用户岗位关系", businessType = BusinessType.INSERT)
    @PostMapping("save")
    public AjaxResult add(@RequestBody ProjectUserPost projectUserPost)
    {
        if(projectUserPost.getId() == null){
            projectUserPostService.insertProjectUserPost(projectUserPost);
        }else{
            projectUserPostService.updateProjectUserPost(projectUserPost);
        }
        return AjaxResult.success();
    }

    /**
     * 修改项目用户岗位关系
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:edit')")
    @Log(title = "项目用户岗位关系", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProjectUserPost projectUserPost)
    {
        return toAjax(projectUserPostService.updateProjectUserPost(projectUserPost));
    }

    /**
     * 删除项目用户岗位关系
     */
    @PreAuthorize("@ss.hasPermi('risk:currentProject:remove')")
    @Log(title = "项目用户岗位关系", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(projectUserPostService.deleteProjectUserPostByIds(ids));
    }
}
