import request from '@/utils/request'

// 查询风险计划列表
export function listPlan(query) {
  return request({
    url: '/system/risk/plan/list',
    method: 'get',
    params: query
  })
}

// 查询风险计划详细
export function getPlan(id) {
  return request({
    url: '/system/risk/plan/' + id,
    method: 'get'
  })
}

// 新增风险计划
export function addPlan(data) {
  return request({
    url: '/system/risk/plan',
    method: 'post',
    data: data
  })
}

// 修改风险计划
export function updatePlan(data) {
  return request({
    url: '/system/risk/plan',
    method: 'put',
    data: data
  })
}

// 删除风险计划
export function delPlan(id) {
  return request({
    url: '/system/risk/plan/' + id,
    method: 'delete'
  })
}
//风险评估信息详情
export function riskListInfo(id) {
  return request({
    url: '/app-api/risk/plan/details/' + id,
    method: 'get'
  })
}
//风险评估清单
export function riskList(query) {
  return request({
    url: '/system/risk/inherent/list',
    method: 'get',
    params: query
  })
}

export function exportRiskList(inherentId) {
  return request({
    url: '/system/risk/plan/exportWord/riskNotification/'+inherentId,
    method: 'get',
  })
}