import request from '@/utils/request'

// 查询现状风险岗位列表
export function listCurrentRiskPost(query) {
  return request({
    url: '/system/currentRiskPost/list',
    method: 'get',
    params: query
  })
}
// 人员列表
export function userCurrentRiskPost(query) {
  return request({
    url: '/risk/currentProject/list',
    method: 'get',
    params: query
  })
}

// 查询现状风险岗位详细
export function getCurrentRiskPost(id) {
  return request({
    url: '/system/currentRiskPost/' + id,
    method: 'get'
  })
}

// 新增现状风险岗位
export function addCurrentRiskPost(data) {
  return request({
    url: '/system/currentRiskPost',
    method: 'post',
    data: data
  })
}

// 修改现状风险岗位
export function updateCurrentRiskPost(data) {
  return request({
    url: '/system/currentRiskPost',
    method: 'put',
    data: data
  })
}

// 删除现状风险岗位
export function delCurrentRiskPost(id) {
  return request({
    url: '/system/currentRiskPost/' + id,
    method: 'delete'
  })
}
// 保存岗位
export function saveCurrentPost(data) {
  return request({
    url: '/system/currentRiskPost/save',
    method: 'post',
    data: data
  })
}

// 隐患清单库
export function getlibraryListFun(query) {
  return request({
    url: '/system/risk/existing/list',
    method: 'get',
    params: query
  })
}
// 岗位用户巡查清单列表
export function getCurrentRiskPatrol(query) {
  return request({
    url: '/risk/riskPostList/list',
    method: 'get',
    params: query
  })
}
