import request from '@/utils/request'
import qs from 'querystring'
// 项目信息列表
export const projectList = (params) => {
    return request({
        url: '/system/bigScreen/selectLedgerProjectList',
        method: 'get',
        params
    })
}


// 项目，楼宇，楼层统计
export const leftEvaluation = (params) => {
    return request({
        url: '/system/bigScreen/evaluationDataStatistics',
        method: 'get',
        params
    })
}


// 全国风险，年度新增
export const centerStatistic = (params) => {
    return request({
        url: '/system/bigScreen/nationalRiskStatistics',
        method: 'get',
        params
    })
}


// 总体风险指数排名
export const leftRiskSort = (params) => {
    return request({
        url: '/system/bigScreen/riskIndexRanking',
        method: 'get',
        params
    })
}


// 年度风险数量统计
export const leftAnnualSort = (params) => {
    return request({
        url: '/system/bigScreen/annualRiskStatistics',
        method: 'get',
        params
    })
}
// 
// 年度风险数量统计
export const rightlevelStatic = (params) => {
    return request({
        url: '/system/bigScreen/riskLevelStatistics',
        method: 'get',
        params
    })
}

// 项目风险级别排名
export const rightAccessLevel = (params) => {
    return request({
        url: '/system/bigScreen/riskProjectRanking',
        method: 'get',
        params
    })
}

export const rightAccidentType = (params) => {
    return request({
        url: '/system/bigScreen/accidentTypeStatistics',
        method: 'get',
        params
    })
}

export const topProjectDetail = (params) => {
    return request({
        url: '/system/bigScreen/projectStatisticsDetail',
        method: 'get',
        params
    })
}


// 获取项目下的楼宇
export const detailBuilding = (id) => {
    return request({
        url: '/system/bigScreen/building/list/' + id,
        method: 'get',
    })
}

// 根据楼宇id获取楼层列表
export const detailFloor = (id) => {
    return request({
        url: '/system/bigScreen/floor/list/' + id,
        method: 'get',
    })
}

// 项目风险信息
export function detailProjectRisk(params) {
    return request({
        url: '/system/bigScreen/projectRiskInformation',
        method: 'get',
        params
    })
}

// 项目风险信息
export function detailDictList(params) {
    return request({
        url: '/system/dict/data/list/all',
        method: 'get',
        params
    })
}

// 获取地图统计数据
export function centerMap(params) {
    return request({
        url: '/system/bigScreen/getRiskMapStatistics',
        method: 'get',
        params
    })
}