import request from '@/utils/request'

// 查询基础数据-楼层列表
export function listFloor(query) {
  return request({
    url: '/system/ledger/floor/list',
    method: 'get',
    params: query
  })
}

// 查询基础数据-楼层详细
export function getFloor(id) {
  return request({
    url: '/system/ledger/floor/' + id,
    method: 'get'
  })
}

// 新增基础数据-楼层
export function addFloor(data) {
  return request({
    url: '/system/ledger/floor',
    method: 'post',
    data: data
  })
}

// 修改基础数据-楼层
export function updateFloor(data) {
  return request({
    url: '/system/ledger/floor',
    method: 'put',
    data: data
  })
}

// 删除基础数据-楼层
export function delFloor(id) {
  return request({
    url: '/system/ledger/floor/' + id,
    method: 'delete'
  })
}
