import request from '@/utils/request'

// 查询基础数据-项目列表
export function listProject(query) {
  return request({
    url: '/system/ledger/project/list',
    method: 'get',
    params: query
  })
}

// 查询基础数据-项目详细
export function getProject(id) {
  return request({
    url: '/system/ledger/project/' + id,
    method: 'get'
  })
}

// 新增基础数据-项目
export function addProject(data) {
  return request({
    url: '/system/ledger/project',
    method: 'post',
    data: data
  })
}

// 修改基础数据-项目
export function updateProject(data) {
  return request({
    url: '/system/ledger/project',
    method: 'put',
    data: data
  })
}

// 删除基础数据-项目
export function delProject(id) {
  return request({
    url: '/system/ledger/project/' + id,
    method: 'delete'
  })
}
