import request from '@/utils/request'

// 查询评估模型信息列表
export function listFactor(query) {
  return request({
    url: '/system/evaluation/factor/list',
    method: 'get',
    params: query
  })
}

// 查询评估模型信息详细
export function getFactor(id) {
  return request({
    url: '/system/evaluation/factor/' + id,
    method: 'get'
  })
}

// 新增评估模型信息
export function addFactor(data) {
  return request({
    url: '/system/evaluation/factor',
    method: 'post',
    data: data
  })
}

// 修改评估模型信息
export function updateFactor(data) {
  return request({
    url: '/system/evaluation/factor',
    method: 'put',
    data: data
  })
}

// 删除评估模型信息
export function delFactor(id) {
  return request({
    url: '/system/evaluation/factor/' + id,
    method: 'delete'
  })
}
