import request from '@/utils/request'

// 查询评估选项管理列表
export function listItems(query) {
  return request({
    url: '/evaluation/items/list',
    method: 'get',
    params: query
  })
}

// 查询评估选项管理详细
export function getItems(id) {
  return request({
    url: '/evaluation/items/' + id,
    method: 'get'
  })
}

// 新增评估选项管理
export function addItems(data) {
  return request({
    url: '/evaluation/items',
    method: 'post',
    data: data
  })
}

// 修改评估选项管理
export function updateItems(data) {
  return request({
    url: '/evaluation/items',
    method: 'put',
    data: data
  })
}

// 删除评估选项管理
export function delItems(id) {
  return request({
    url: '/evaluation/items/' + id,
    method: 'delete'
  })
}
