import request from '@/utils/request'

// 查询基础数据-楼层列表
export function listRoom(query) {
  return request({
    url: '/system/ledger/room/list',
    method: 'get',
    params: query
  })
}

// 查询基础数据-楼层详细
export function getRoom(id) {
  return request({
    url: '/system/ledger/room/' + id,
    method: 'get'
  })
}

// 新增基础数据-楼层
export function addRoom(data) {
  return request({
    url: '/system/ledger/room',
    method: 'post',
    data: data
  })
}

// 修改基础数据-楼层
export function updateRoom(data) {
  return request({
    url: '/system/ledger/room',
    method: 'put',
    data: data
  })
}

// 删除基础数据-楼层
export function delRoom(id) {
  return request({
    url: '/system/ledger/room/' + id,
    method: 'delete'
  })
}
