import request from '@/utils/request'

// 查询固有风险清单库列表
export function listInherent(query) {
  return request({
    url: 'system/risk/inherentDB/list',
    method: 'get',
    params: query
  })
}

// 查询固有风险清单库详细
export function getInherent(id) {
  return request({
    url: 'system/risk/inherentDB/' + id,
    method: 'get'
  })
}

// 新增固有风险清单库
export function addInherent(data) {
  return request({
    url: 'system/risk/inherentDB',
    method: 'post',
    data: data
  })
}

// 修改固有风险清单库
export function updateInherent(data) {
  return request({
    url: 'system/risk/inherentDB',
    method: 'put',
    data: data
  })
}

// 删除固有风险清单库
export function delInherent(id) {
  return request({
    url: 'system/risk/inherentDB/' + id,
    method: 'delete'
  })
}
