import request from '@/utils/request'

// 查询基础数据-楼宇列表
export function listBuilding(query) {
  return request({
    url: '/system/ledger/building/list',
    method: 'get',
    params: query
  })
}

// 查询基础数据-楼宇详细
export function getBuilding(id) {
  return request({
    url: '/system/ledger/building/' + id,
    method: 'get'
  })
}

// 新增基础数据-楼宇
export function addBuilding(data) {
  return request({
    url: '/system/ledger/building',
    method: 'post',
    data: data
  })
}

// 修改基础数据-楼宇
export function updateBuilding(data) {
  return request({
    url: '/system/ledger/building',
    method: 'put',
    data: data
  })
}

// 删除基础数据-楼宇
export function delBuilding(id) {
  return request({
    url: '/system/ledger/building/' + id,
    method: 'delete'
  })
}
