import request from '@/utils/request'

// 查询现有风险清单库列表
export function listList(query) {
  return request({
    url: '/system/risk/existing/list/list',
    method: 'get',
    params: query
  })
}

// 查询现有风险清单库详细
export function getList(id) {
  return request({
    url: '/system/risk/existing/list' + id,
    method: 'get'
  })
}

// 新增现有风险清单库
export function addList(data) {
  return request({
    url: '/system/risk/existing/list',
    method: 'post',
    data: data
  })
}

// 修改现有风险清单库
export function updateList(data) {
  return request({
    url: '/system/risk/existing/list',
    method: 'put',
    data: data
  })
}

// 删除现有风险清单库
export function delList(id) {
  return request({
    url: '/system/risk/existing/list/' + id,
    method: 'delete'
  })
}
