import request from '@/utils/request'

// 查询法律法规库列表
export function listList(query) {
  return request({
    url: '/system/law/list/list',
    method: 'get',
    params: query
  })
}

// 查询法律法规库详细
export function getList(id) {
  return request({
    url: '/system/law/list/' + id,
    method: 'get'
  })
}

// 新增法律法规库
export function addList(data) {
  return request({
    url: '/system/law/list',
    method: 'post',
    data: data
  })
}

// 修改法律法规库
export function updateList(data) {
  return request({
    url: '/system/law/list',
    method: 'put',
    data: data
  })
}

// 删除法律法规库
export function delList(id) {
  return request({
    url: '/system/law/list/' + id,
    method: 'delete'
  })
}
