import request from '@/utils/request'

// 查询风险计划列表
export function listPlan(query) {
  return request({
    url: '/system/risk/plan/list',
    method: 'get',
    params: query
  })
}

// 查询风险计划详细
export function getPlan(id) {
  return request({
    url: '/system/risk/plan/' + id,
    method: 'get'
  })
}

// 新增风险计划
export function addPlan(data) {
  return request({
    url: '/app-api/risk/plan',
    method: 'post',
    data: data
  })
}

// 修改风险计划
export function updatePlan(data) {
  return request({
    url: '/app-api/risk/plan',
    method: 'put',
    data: data
  })
}

// 删除风险计划
export function delPlan(id) {
  return request({
    url: '/system/risk/plan/' + id,
    method: 'delete'
  })
}
//风险评估信息详情
export function riskListInfo(id) {
  return request({
    url: '/app-api/risk/plan/details/' + id,
    method: 'get'
  })
}
//风险评估清单
export function riskList(query) {
  return request({
    url: '/system/risk/inherent/list',
    method: 'get',
    params: query
  })
}

export function exportRiskList(inherentId) {
  return request({
    url: '/system/risk/plan/exportWord/riskNotification/'+inherentId,
    method: 'get',
  })
}

//项目列表
export function getProjectList(projectName) {
  return request({
    url: '/system/ledger/project/listByQuery/'+projectName,
    method: 'get',
  })
}

//楼栋列表
export function getBuildingList(projectId) {
  return request({
    url: '/app-api/risk/plan/building/list/'+projectId,
    method: 'get',
  })
}

//根据单位id查询用户列表
export function getUserListByDeptId(deptId) {
  return request({
    url: '/app-api/risk/plan/user/list/'+deptId,
    method: 'get',
  })
}

//根据固有风险id查看固有风险信息

export function getInherentById(inherentId) {
  return request({
    url: '/app-api/risk/plan/inherent/details/'+inherentId,
    method: 'get',
  })
}

//风险现有风险清单
export function getExsitingList(query) {
  return request({
    url: '/system/risk/existing/list/',
    method: 'get',
    params: query
  })
}

//根据固有风险id查看固有风险信息

export function getExistingById(exsitingId) {
  return request({
    url: '/app-api/risk/plan/existing/details/'+exsitingId,
    method: 'get',
  })
}


