import Vue from 'vue'
import VueRouter from 'vue-router'
Vue.use(VueRouter)

const routes = [{
  path: '/',
  redirect: '/login'
},
// 登录页
{
  path: '/login',
  name: 'login',
  component: () => import('../views/login.vue'),
},
// 我的地盘页面
{
  path: '/my',
  name: 'my',
  component: () => import('../views/my'),
},
{
  path: '/my-role',
  name: 'my-role',
  meta: {
    title: '我的权限'
  },
  component: () => import('@/views/my/role')
},
{
  path: '/my-reset-pas',
  name: 'my-reset-pas',
  meta: {
    title: '修改密码'
  },
  component: () => import('@/views/my/resetPas')
},
// 安全工作台页面
{
  path: '/save-workbench',
  name: 'save-workbench',
  component: () => import('../views/saveWorkbench'),
},
// 创建任务页面
{
  path: '/create-task',
  name: 'create-task',
  component: () => import('../views/createTask'),
},
// 选择任务类型
{
  path: '/task-type',
  name: 'task-type',
  component: () => import('../views/createTask/taskSubPage/taskType.vue'),
},
// 选择作业任务
{
  path: '/work-task',
  name: 'work-task',
  component: () => import('../views/createTask/taskSubPage/workTask'),
},
// 选择作业综合班
{
  path: '/work-class',
  name: 'work-class',
  component: () => import('../views/createTask/taskSubPage/workClass'),
},
// 选择作业综合组
{
  path: '/work-group',
  name: 'work-group',
  component: () => import('../views/createTask/taskSubPage/workGroup'),
},
// 选择作业负责人
{
  path: '/work-leader',
  name: 'work-leader',
  component: () => import('../views/createTask/taskSubPage/workLeader'),
},
// 选择作业其他人员
{
  path: '/work-other-per',
  name: 'work-other-per',
  component: () => import('../views/createTask/taskSubPage/workOtherPer'),
},
// 选择微流域
{
  path: '/micro-watersh',
  name: 'micro-watersh',
  component: () => import('../views/createTask/taskSubPage/microWatersh'),
},
// 选择管段
{
  path: '/pipe-section',
  name: 'pipe-section',
  component: () => import('../views/createTask/taskSubPage/pipeSection'),
},
// 选择车牌号
{
  path: '/license-plate',
  name: 'license-plate',
  component: () => import('../views/createTask/taskSubPage/licensePlate'),
},
// 选择手杆爬行器
{
  path: '/work-device',
  name: 'work-device',
  component: () => import('../views/createTask/taskSubPage/workDevice'),
},


//风险项目新增
{
  path: '/riskAdd',
  name: 'riskAdd',
  component: () => import('../views/riskProject/add'),
},
//风险项目管理
{
  path: '/riskManage',
  name: 'riskManage',
  component: () => import('../views/riskProject/manage'),
},
//风险评估
{
  path: '/riskAssess',
  name: 'riskAssess',
  component: () => import('../views/riskProject/assess'),
},
//风险审批
{
  path: '/riskApprove',
  name: 'riskApprove',
  component: () => import('../views/riskProject/approve'),
},
//风险台账
{
  path: '/riskLedger',
  name: 'riskLedger',
  component: () => import('../views/riskProject/ledger'),
},
//任务单
{
  path: '/riskTaskList',
  name: 'riskTaskList',
  component: () => import('../views/riskProject/add/taskList.vue'),
},
//固有风险列表
{
  path: '/riskInherent',
  name: 'riskInherent',
  component: () => import('../views/riskProject/add/inherentRisks.vue'),
},
//新增固有风险
{
  path: '/addInherent',
  name: 'addInherent',
  component: () => import('../views/riskProject/add/addInherent.vue'),
},
{//编辑固有风险
  path: '/addCurrent',
  name: 'addCurrent',
  component: () => import('../views/riskProject/add/addCurrent.vue'),
},
{//新增现状风险
  path: '/addPresent ',
  name: 'addPresent',
  component: () => import('../views/riskProject/add/addPresent.vue'),
},
{//风险评估列表详情页
  path: '/riskBigDetail',
  name: 'riskBigDetail',
  component: () => import('../views/riskProject/assess/riskBigDetail.vue'),
},
{//执行情况管理
  path: '/riskExecution',
  name: 'riskExecution',
  component: () => import('../views/riskProject/execution/index.vue'),
},
{//四色图
  path: '/riskView',
  name: 'riskView',
  component: () => import('../views/drawCanvas/riskView.vue'),
},
{//任务台账
  path: '/taskLedger',
  name: 'taskLedger',
  component: () => import('../views/riskProject/taskLedger/index.vue'),
},
{//任务台账
  path: '/taskDetail',
  name: 'taskDetail',
  component: () => import('../views/riskProject/taskLedger/taskDetail.vue'),
},
{//任务台账
  path: '/resultPage',
  name: 'resultPage',
  component: () => import('../views/riskProject/add/resultPage.vue'),
},
{//任务台账
  path: '/riskAppvoreText',
  name: 'riskAppvoreText',
  component: () => import('../views/riskProject/add/riskAppvoreText.vue'),
}
]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes
})

export default router
