import router from './router'
//设置白名单，指不需要登录就可以直接进入的页面
var whiteList = ["/login"]
import { getToken } from '@/utils/auth' // get token from cookie
import { getUserInfo} from '@/utils/userInfo'
//这里使用cookie.js，登录成功后将后台返回的token保存在cookie中
// Cookies.set('admin_token','token_value');
router.beforeEach(async(to, from, next) => {
    //to: 即将要进入的目标 [路由对象]
    //from:当前导航正要离开的路由
    //next:一定要调用该方法来 resolve 这个钩子
    const hasToken = getToken()//确定用户是否已登录
    const hasUserInfo = getUserInfo()// 确认session 是否有用户信息
     if (hasToken && hasUserInfo) {
        if (to.path === '/login') {
            next({ path: '/save-workbench' })
        } else { 
            next()
        } 
      }else {
        if (whiteList.indexOf(to.path) !== -1) {
            next()//这里是即将进入的页面是白名单的页面就直接进入
        } else { 
            next({ path: '/login' })//这里是即将进入的页面不是白名单的页面又没有token的情况下重定向到登录页面进行登录操作
        } 
      }
})