package com.censoft.db;

import com.censoft.common.base.Pub;
import com.censoft.common.db.ConnectionFactory;

import javax.servlet.http.HttpServletRequest;
import java.sql.Connection;

public class Logger {
    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
            if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
                //根据网卡取本机配置的IP
                java.net.InetAddress inet = null;
                try {
                    inet = java.net.InetAddress.getLocalHost();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                ip = inet.getHostAddress();
            }
        }
        return ip;
    }

    /**
     * 系统操作日志
     *
     * @param model_name--模块名称，写中文
     * @param action--动作，写中文
     * @param yw_id--业务id
     * @param content--内容
     * @param request
     * @return
     */
    public static boolean log(String model_name, String action, String yw_id, String content, HttpServletRequest request) {
        boolean is_in = false;
        ConnectionFactory cf = new ConnectionFactory();
        Pub pub = new Pub();
        Connection conn = null;
        try {
            conn = com.censoft.db.DBUtil.getConnection();
            String sql = "insert into t_book_log(id,model,action,ip,add_user,add_time,yw_id,content) values (?,?,?,?,?,?,?,?)";
            is_in = cf.executeUpdate(conn, sql, new Object[]{DBUtil.getUUID(), model_name, action, getIpAddress(request), request.getSession().getAttribute("session_login_id"), pub.getCurrentServerTime(), yw_id, content});
            if (!is_in) {
                System.out.println("插入日誌出错" + cf.getMsg());
                return false;
            }
        } catch (Exception e) {
            System.out.println("插入日誌出错异常" + e);
            return false;
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (Exception e) {
                }
            }
        }
        return is_in;
    }
    public static boolean log(Connection conn,String model_name, String action, String yw_id, String content, HttpServletRequest request) {
        boolean is_in = false;
        ConnectionFactory cf = new ConnectionFactory();
        Pub pub = new Pub();
        try {
            String sql = "insert into t_book_log(id,model,action,ip,add_user,add_time,yw_id,content) values (?,?,?,?,?,?,?,?)";
            is_in = cf.executeUpdate(conn, sql, new Object[]{DBUtil.getUUID(), model_name, action, getIpAddress(request), request.getSession().getAttribute("session_login_id"), pub.getCurrentServerTime(), yw_id, content});
            if (!is_in) {
                System.out.println("插入日誌出错" + cf.getMsg());
                return false;
            }
        } catch (Exception e) {
            System.out.println("插入日誌出错异常" + e);
            return false;
        }
        return is_in;
    }
}
