
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<link rel="stylesheet" href="<%=request.getContextPath()%>/css/simple-calendar.css">
<script src="<%=request.getContextPath()%>/js/simple-calendar-es6.js"></script>
<style>
    #container{
        margin: 0 auto;
        float: none;
        width: 95%;
        height: 600px;
    }
</style>
<div style="margin-top: 10px;display: none;">
    <a class="btn btn-primary radius" onclick="operList();" >
        导出
    </a>
</div>
<div style="margin-top: 10px;text-align: right;margin-right: 40px;">
    <a class="btn btn-primary radius" onclick="zdPb();" >
        自动排班
    </a>
    <a class="btn btn-primary radius" onclick="viewUserWeek();" >
        周排班表
    </a>
    <a class="btn btn-primary radius" onclick="changeZb();" >
        换班
    </a>
</div>
<div id="container"></div>
<form  method="post" id="form1" name="form1" action="export_query.jsp" >
    <input type="hidden" value="" id="nowDays" name="nowDays">
    <input type="hidden" value="" id="nowYear" name="nowYear">
    <input type="hidden" value="" id="nowMonth" name="nowMonth">
</form>
<script>
    let myCalendar = new SimpleCalendar('#container');
    //刷新日历
    function addData(year, month) {
        var totalDays="";
        var now = new Date();//当前日期
        var nowDay = now.getDate();// 当天
        var nowYear = now.getFullYear();// 年份
        var nowMonth = now.getMonth() + 1;// 月份
        let daysElement = arrayfrom(this.container.querySelectorAll('.sc-item'));
        let day = new Date(year, month - 1, 0);
        let week = day.getDay();
        if (week == 0) week = 7;
        if (week == 7) week = 0;
        //计算得到第一个格子的日期
        let thispageStart = new Date(Date.parse(day) - (week - 1) * 24 * 3600 * 1000);
        //对每一个格子遍历
        for (let i = 0; i < 35; i++) {
            daysElement[i].className = 'sc-item';
            let theday = new Date(Date.parse(thispageStart) + (i-1) * 24 * 3600 * 1000);
            let writeyear = theday.getFullYear();
            let writeday = theday.getDate();
            let writemonth = theday.getMonth() + 1;
            if (writemonth != month) {
                daysElement[i].classList.add('sc-othermenth');
            }
            daysElement[i].querySelector('.day').innerHTML = writeday;
            getZbUser(writeyear,writemonth,writeday,i);
            //daysElement[i].querySelector('.zb_user_button').innerHTML = '<span onclick="editUser('+writeyear+','+writemonth+','+writeday+');" style="text-align:center;position:absolute; right:0; bottom:0;"><img src="../../images/edit.png" width="20" height="15" /></span>';
            //判断是否添加阴历
            if (true) {
                daysElement[i].querySelector('.lunar-day').innerHTML = (new LunarHelp(writeyear, writemonth, writeday)).getLunarDayName();
            } else {
                daysElement[i].querySelector('.lunar-day').innerHTML = '';
                daysElement[i].classList.add('item-nolunar');
            }
            //console.log(writeyear+""+writemonth+""+writeday);
            //添加today样式
            if (nowYear == writeyear && nowDay == writeday && nowMonth == writemonth) {
                this.selectDay = daysElement[i];
                daysElement[i].classList.add("sc-today");
            }
            if (year == writeyear &&  month == writemonth) {
                totalDays+=writeday+",";
            }

        }
        $("#nowYear").val(year);
        $("#nowMonth").val(month);
        $("#nowDays").val(totalDays.substring(0,totalDays.length-1));
    }
    function getZbUser(year,month,day,index) {
        let daysElement = arrayfrom(this.container.querySelectorAll('.sc-item'));
        $.ajax({
            type: "post",
            url: "list_ajax.jsp?year="+year+"&month="+month+"&day="+day,
            success: function (msg) {
                daysElement[index].querySelector('.zb_user').innerHTML = msg;
                daysElement[index].querySelector('.zb_user').setAttribute("onclick","viewUser("+year+","+month+","+day+")");
            }
        });
    }
    function arrayfrom(nidelist) {
        let array = [];
        [].forEach.call(nidelist, function(v) {
            array.push(v);
        });
        return array;
    }
    function viewUser(year,month,day) {
        var url = './viewUser-t.jsp?year='+year+'&month='+month+'&day='+day;
        viewDeptOrUserInfo(year+'年'+month+'月'+day+'日值班表', url, '1100', '550');
    }
    function changeZb() {
        var url = './changeZb-t.jsp';
        viewDeptOrUserInfo('换班', url, '1000', '500');
    }
    function viewUserWeek() {
        var url = './viewUserWeek-t.jsp';
        viewUserWeekFull('周值班表', url, '1000', '500');
    }
    function viewUserWeekFull(title, url, w, h) {
        var abc = layer.open({
            title: title,
            type: 2,
            content: url,
            area: [w, h],
            maxmin: true
        });
        layer.full(abc);
    }
    function zdPb() {
        var url = './edit-t.jsp';
        viewDeptOrUserInfo('自动排班', url, '1000', '500');
    }
    function viewDeptOrUserInfo(title, url, w, h) {
        var abc = layer.open({
            title: title,
            type: 2,
            content: url,
            area: [w+'px', h+'px'],
            maxmin: true
        });
        //layer.full(abc);
    }
</script>
