
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<link rel="stylesheet" href="<%=request.getContextPath()%>/css/rili.css">
<div style="margin-top: 10px;">
    <a class="btn btn-primary radius" onclick="operList();" >
        导出
    </a>
</div>
<div id="calendar" class="calendar">
</div>
<form  method="post" id="form1" name="form1" action="export_query.jsp" >
    <input type="hidden" value="" id="nowDays" name="nowDays">
    <input type="hidden" value="" id="nowYear" name="nowYear">
    <input type="hidden" value="" id="nowMonth" name="nowMonth">
</form>
<script>
    var now = new Date();//当前日期
    var year = now.getFullYear();// 年份
    var month = now.getMonth() + 1;// 月份
    var nowMonth=month;
    var nowYear=year;
    var preMonth = now.getMonth();// 上个月
    var nowDay = now.getDate();// 当天
    var nextMonth = month + 1;// 下个月
    var days,whatday,predays; //days表示当月天数，predays表示上个月天数，whatday表示当月一号所在的是周几
    var weeks = ['一','二','三','四','五','六','日'];//设置头部是从周一开始还是周日开始
    var begin;//传入参数，用于设置上一个月还剩几天的天数显示
    function setNewDate(){//设置日期的方法
        if(month == 1){ //当前月为1月时，上一个月显示为12月
            preMonth = 12;
        }
        if(month == 12){ //当前月为12月时，下一个月显示为1月
            nextMonth = 1;
        }
        now.setFullYear(year, month, 0);
        days = now.getDate();//当前月天数
        now.setDate(1);//获取的是1号
        whatday = now.getDay();// 获取1号在周几
        now.setFullYear(year, month - 1, 0);
        predays = now.getDate();// 上个月天数
        begin = predays - whatday + 2; // 设置上一个月还剩几天的天数显示
        getCalendar(weeks, begin, whatday - 1); //传入参数，调用getCalender方法
    }
    setNewDate(); // 初始化日期
    function getCalendar(weeks, begin, whichday){
        var totalDays="";
        var calBox = document.getElementById("calendar"); //获取日历的dom对象
        var str = "<div class='title'>\
                <div id='calendar-pre'>&lt;上月（\
                " + preMonth + "月）</div><label>\
                "+year+"年</label><label>" +month+"\
                月</label> <div id='calendar-next'>下月\
                （"+nextMonth+"月）&gt;</div> </div>" //渲染表格基础信息
        str += "<table class='calendar-table'>"
        str += "<tr>"
        for(var i = 0; i < 7;i++){ //渲染头部
            str += "<th>" + weeks[i] + "</th>"
        }
        str += "</tr>";
        var line = Math.ceil((days + whichday) / 7); // 行数
        var curIndex = 1; //当前天
        var start = begin; //上一个月遗留的天数显示
        var flag = false; //这个月的天数是否渲染完成
        for(var l = 0; l < line; l++){
            str += "<tr>";
            for(var i = 0; i < 7; i++){ //一周七天
                if(i < whichday && l == 0){ //当i小于一号所在的周几数就表示上个月还剩余天数未渲染
                    str += "<td style='color:#989898;'><div id='divId_"+(month-1)+'_'+start+"'>" + start + "</div></td>" ; //渲染上个月的剩余天数，并置为灰色
                    start++;
                }else if(curIndex > days || flag == true){ //当月天数渲染完之后，剩余的位置用于渲染下个月的天数
                    flag == true;
                    str += "<td style='color:#989898;'><div id='divId_"+(month+1)+'_'+(curIndex - days)+"'>" + (curIndex - days) + "</div></td>" ;
                    curIndex++;
                }else{ //渲染当月的天数
                    getZbUser(year,month,curIndex,"divId_"+month+'_'+curIndex);
                    if(nowDay==curIndex&&month==nowMonth&&year==nowYear){
                        str += "<td style='background-color: #00B83F;color:#fff;'><div id='divId_"+month+'_'+curIndex+"'>" + curIndex + "" +
                            "</div></td>" ;
                    }else{
                        str += "<td><div id='divId_"+month+'_'+curIndex+"'>" + curIndex + "</div></td>" ;
                    }
                    totalDays+=curIndex+",";
                    curIndex++;
                }
            }
            str += "</tr>";
        }
        $("#nowDays").val(totalDays.substring(0,totalDays.length-1));
        $("#nowYear").val(year);
        $("#nowMonth").val(month);
        str += "</table>"
        calBox.innerHTML = str;
    }
    calendar.addEventListener("click",function(e){ //为两个按钮设置事件委托
        if(e.target.id == "calendar-pre"){ //当点击上一个月的按钮时
            month = preMonth;
            preMonth = month - 1;
            nextMonth = month + 1;
            if(month == 12){ //边界值判断
                year--;
            }
            setNewDate(); //更新日期
        }
        if(e.target.id == "calendar-next"){ //当点击下一个月的按钮时
            month = nextMonth;
            preMonth = month - 1;
            nextMonth = month + 1;
            if(month == 1){ //边界值判断
                year++;
            }
            setNewDate(); //更新日期
        }
    });
    function getZbUser(year,month,day,divId) {
        $.ajax({
            type: "post",
            url: "list_ajax.jsp?year="+year+"&month="+month+"&day="+day,
            success: function (msg) {
                $("#"+divId).after(msg);
            }
        });
    }
    function operList() {
        document.form1.submit();
    }
</script>
