/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ExceptionHolderImpl;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.ServantObject;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.Messaging.ReplyHandler;
import org.omg.TimeBase.UtcT;

public class ReplyReceiver
extends ReplyPlaceholder
implements Configurable {
    private Delegate delegate = null;
    private ClientInterceptorHandler interceptors = null;
    private ReplyHandler replyHandler = null;
    private String operation;
    private UtcT replyEndTime;
    private Timer timer;
    private Configuration configuration = null;
    private Logger logger;
    private boolean retry_on_failure = false;

    public ReplyReceiver(Delegate delegate, String string, UtcT utcT, ClientInterceptorHandler clientInterceptorHandler, ReplyHandler replyHandler) {
        super((ORB)delegate.orb(null));
        this.delegate = delegate;
        this.operation = string;
        this.replyEndTime = utcT;
        this.interceptors = clientInterceptorHandler;
        this.replyHandler = replyHandler;
        if (utcT != null) {
            this.timer = new Timer(utcT);
            this.timer.setName("ReplyReceiver Timer");
            this.timer.start();
        } else {
            this.timer = null;
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.orb.rep_recv");
        this.retry_on_failure = configuration.getAttribute("jacorb.connection.client.retry_on_failure", "off").equals("on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream messageInputStream) {
        Set set;
        if (this.timeoutException) {
            return;
        }
        if (this.timer != null) {
            this.timer.wakeup();
        }
        Set set2 = set = this.delegate.get_pending_replies();
        synchronized (set2) {
            ReplyReceiver replyReceiver = this;
            synchronized (replyReceiver) {
                if (this.timeoutException) {
                    return;
                }
                this.in = messageInputStream;
                this.delegate.replyDone(this);
                if (this.replyHandler != null) {
                    this.performCallback((ReplyInputStream)messageInputStream);
                } else {
                    this.ready = true;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCallback(ReplyInputStream replyInputStream) {
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject servantObject = delegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        try {
            switch (replyInputStream.getStatus().value()) {
                case 0: {
                    ((InvokeHandler)servantObject.servant)._invoke(this.operation, replyInputStream, new DummyResponseHandler());
                    return;
                }
                case 1: 
                case 2: {
                    ExceptionHolderImpl exceptionHolderImpl = new ExceptionHolderImpl(replyInputStream);
                    org.omg.CORBA_2_3.ORB oRB = (org.omg.CORBA_2_3.ORB)delegate.orb(null);
                    oRB.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
                    CDRInputStream cDRInputStream = new CDRInputStream(oRB, exceptionHolderImpl.marshal());
                    ((InvokeHandler)servantObject.servant)._invoke(this.operation + "_excep", cDRInputStream, new DummyResponseHandler());
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            if (!this.logger.isWarnEnabled()) return;
            this.logger.warn("Exception during callback: " + exception.getMessage());
            return;
        }
        finally {
            delegate.servant_postinvoke(this.replyHandler, servantObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performExceptionCallback(ExceptionHolderImpl exceptionHolderImpl) {
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)((java.lang.Object)this.replyHandler))._get_delegate();
        ServantObject servantObject = delegate.servant_preinvoke(this.replyHandler, this.operation, InvokeHandler.class);
        try {
            org.omg.CORBA_2_3.ORB oRB = (org.omg.CORBA_2_3.ORB)delegate.orb(null);
            oRB.register_value_factory("IDL:omg.org/Messaging/ExceptionHolder:1.0", new ExceptionHolderFactory());
            CDRInputStream cDRInputStream = new CDRInputStream(oRB, exceptionHolderImpl.marshal());
            ((InvokeHandler)servantObject.servant)._invoke(this.operation + "_excep", cDRInputStream, new DummyResponseHandler());
        }
        catch (Exception exception) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception during callback: " + exception.getMessage());
            }
        }
        finally {
            delegate.servant_postinvoke(this.replyHandler, servantObject);
        }
    }

    public synchronized ReplyInputStream getReply() throws RemarshalException, ApplicationException {
        try {
            try {
                this.getInputStream();
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (this.retry_on_failure) {
                    throw new RemarshalException();
                }
                throw cOMM_FAILURE;
            }
        }
        catch (SystemException systemException) {
            this.interceptors.handle_receive_exception(systemException);
            throw systemException;
        }
        catch (RemarshalException remarshalException) {
            this.delegate.waitOnBarrier();
            throw new RemarshalException();
        }
        ReplyInputStream replyInputStream = (ReplyInputStream)this.in;
        ReplyStatusType_1_2 replyStatusType_1_2 = this.delegate.doNotCheckExceptions() ? ReplyStatusType_1_2.NO_EXCEPTION : replyInputStream.getStatus();
        switch (replyStatusType_1_2.value()) {
            case 0: {
                this.interceptors.handle_receive_reply(replyInputStream);
                return replyInputStream;
            }
            case 1: {
                ApplicationException applicationException = this.getApplicationException(replyInputStream);
                this.interceptors.handle_receive_exception(applicationException, replyInputStream);
                throw applicationException;
            }
            case 2: {
                SystemException systemException = SystemExceptionHelper.read(replyInputStream);
                this.interceptors.handle_receive_exception(systemException, replyInputStream);
                throw systemException;
            }
            case 3: 
            case 4: {
                Object object = replyInputStream.read_Object();
                this.interceptors.handle_location_forward(replyInputStream, object);
                this.doRebind(object);
                throw new RemarshalException();
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Got reply status NEEDS_ADDRESSING_MODE (not implemented).");
            }
        }
        throw new MARSHAL("Received unexpected reply status: " + replyStatusType_1_2.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRebind(Object object) {
        try {
            Set set;
            this.delegate.lockBarrier();
            Set set2 = set = this.delegate.get_pending_replies();
            synchronized (set2) {
                for (ReplyPlaceholder replyPlaceholder : set) {
                    replyPlaceholder.retry();
                }
            }
            this.delegate.rebind(object);
        }
        finally {
            this.delegate.openBarrier();
        }
    }

    private ApplicationException getApplicationException(ReplyInputStream replyInputStream) {
        String string;
        block2: {
            replyInputStream.mark(0);
            string = replyInputStream.read_string();
            try {
                replyInputStream.reset();
            }
            catch (IOException iOException) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error("Exception int reset(): " + iOException.getMessage());
            }
        }
        return new ApplicationException(string, replyInputStream);
    }

    private class Timer
    extends Thread {
        private boolean awakened = false;
        private UtcT endTime;

        public Timer(UtcT utcT) {
            this.endTime = utcT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Timer timer = this;
            synchronized (timer) {
                ReplyReceiver.this.timeoutException = false;
                if (!this.awakened) {
                    block12: {
                        long l = Time.millisTo(this.endTime);
                        if (l > 0L) {
                            try {
                                this.wait(l);
                            }
                            catch (InterruptedException interruptedException) {
                                if (!ReplyReceiver.this.logger.isInfoEnabled()) break block12;
                                ReplyReceiver.this.logger.info("Interrupted while waiting for timeout");
                            }
                        }
                    }
                    if (!this.awakened) {
                        ReplyReceiver replyReceiver = ReplyReceiver.this;
                        synchronized (replyReceiver) {
                            ReplyReceiver.this.timeoutException = true;
                            if (ReplyReceiver.this.replyHandler != null) {
                                ExceptionHolderImpl exceptionHolderImpl = new ExceptionHolderImpl(new TIMEOUT());
                                ReplyReceiver.this.performExceptionCallback(exceptionHolderImpl);
                            }
                            ReplyReceiver.this.ready = true;
                            ReplyReceiver.this.notifyAll();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            Timer timer = this;
            synchronized (timer) {
                this.awakened = true;
                ReplyReceiver.this.timeoutException = false;
                this.notifyAll();
            }
        }
    }

    private static class ExceptionHolderFactory
    implements ValueFactory {
        private ExceptionHolderFactory() {
        }

        public Serializable read_value(InputStream inputStream) {
            ExceptionHolderImpl exceptionHolderImpl = new ExceptionHolderImpl();
            exceptionHolderImpl._read(inputStream);
            return exceptionHolderImpl;
        }
    }

    private class DummyResponseHandler
    implements ResponseHandler {
        private DummyResponseHandler() {
        }

        public OutputStream createReply() {
            Time.waitFor(ReplyReceiver.this.delegate.getReplyStartTime());
            return null;
        }

        public OutputStream createExceptionReply() {
            return null;
        }
    }
}

