/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.container.CORBAObjectComponentAdapter;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.ConsumerAdminImplMBean;
import org.jacorb.notification.servant.ECProxyPullSupplierImpl;
import org.jacorb.notification.servant.ECProxyPushSupplierImpl;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.IEventChannel;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPullSupplierImpl;
import org.jacorb.notification.servant.SequenceProxyPushSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPullSupplierImpl;
import org.jacorb.notification.servant.StructuredProxyPushSupplierImpl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPullSupplierHelper;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminOperations;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;

public class ConsumerAdminImpl
extends AbstractAdmin
implements ConsumerAdminOperations,
Disposable,
ProxyEventListener,
ConsumerAdminImplMBean {
    private static final FilterstageWithMessageConsumerComparator FILTERSTAGE_COMPARATOR = new FilterstageWithMessageConsumerComparator();
    private final FilterStageListManager listManager_ = new FilterStageListManager(){

        protected void fetchListData(FilterStageListManager.FilterStageList filterStageList) {
            this.addAllValues(filterStageList, ConsumerAdminImpl.this.pullServants_);
            this.addAllValues(filterStageList, ConsumerAdminImpl.this.pushServants_);
        }

        protected void doSortCheckedList(List list) {
            Collections.sort(list, FILTERSTAGE_COMPARATOR);
        }

        private void addAllValues(FilterStageListManager.FilterStageList filterStageList, Map map) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                filterStageList.add((FilterStage)iterator.next().getValue());
            }
        }
    };
    private MappingFilter priorityFilter_;
    private MappingFilter lifetimeFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));

    public ConsumerAdminImpl(IEventChannel iEventChannel, ORB oRB, POA pOA, Configuration configuration, MessageFactory messageFactory, OfferManager offerManager, SubscriptionManager subscriptionManager) {
        super(iEventChannel, oRB, pOA, configuration, messageFactory, offerManager, subscriptionManager);
        this.priorityFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));
        this.addProxyEventListener(this);
        ConsumerAdmin consumerAdmin = ConsumerAdminHelper.narrow(this.activate());
        this.container_.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new CORBAObjectComponentAdapter(ConsumerAdmin.class, consumerAdmin)));
        this.registerDisposable(new Disposable(){

            public void dispose() {
                ConsumerAdminImpl.this.container_.unregisterComponent(ConsumerAdmin.class);
            }
        });
    }

    public Servant newServant() {
        return new ConsumerAdminPOATie(this);
    }

    public void subscription_change(EventType[] eventTypeArray, EventType[] eventTypeArray2) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(eventTypeArray, eventTypeArray2);
    }

    public ProxySupplier get_proxy_supplier(int n) throws ProxyNotFound {
        return ProxySupplierHelper.narrow(this.getProxy(n).activate());
    }

    public void lifetime_filter(MappingFilter mappingFilter) {
        this.lifetimeFilter_ = mappingFilter;
    }

    public MappingFilter lifetime_filter() {
        return this.lifetimeFilter_;
    }

    public MappingFilter priority_filter() {
        return this.priorityFilter_;
    }

    public void priority_filter(MappingFilter mappingFilter) {
        this.priorityFilter_ = mappingFilter;
    }

    public ProxySupplier obtain_notification_pull_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy abstractProxy = this.obtain_notification_pull_supplier_servant(clientType);
            intHolder.value = abstractProxy.getID();
            return ProxySupplierHelper.narrow(abstractProxy.activate());
        }
        catch (Exception exception) {
            this.logger_.fatalError("obtain_notification_pull_supplier: unexpected error", (Throwable)exception);
            throw new UNKNOWN(exception.getMessage());
        }
    }

    protected void configureMappingFilters(AbstractProxySupplier abstractProxySupplier) {
        if (this.lifetimeFilter_ != null) {
            abstractProxySupplier.lifetime_filter(this.lifetimeFilter_);
        }
        if (this.priorityFilter_ != null) {
            abstractProxySupplier.priority_filter(this.priorityFilter_);
        }
    }

    private AbstractProxy obtain_notification_pull_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier abstractProxySupplier = this.newProxyPullSupplier(clientType);
        this.configureMappingFilters(abstractProxySupplier);
        this.configureQoS(abstractProxySupplier);
        this.configureInterFilterGroupOperator(abstractProxySupplier);
        this.addProxyToMap(abstractProxySupplier, this.pullServants_, this.modifyProxiesLock_);
        return abstractProxySupplier;
    }

    public int[] pull_suppliers() {
        return this.get_all_notify_proxies(this.pullServants_, this.modifyProxiesLock_);
    }

    public int[] push_suppliers() {
        return this.get_all_notify_proxies(this.pushServants_, this.modifyProxiesLock_);
    }

    public ProxySupplier obtain_notification_push_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy abstractProxy = this.obtain_notification_push_supplier_servant(clientType);
            intHolder.value = abstractProxy.getID();
            return ProxySupplierHelper.narrow(abstractProxy.activate());
        }
        catch (Exception exception) {
            this.logger_.fatalError("obtain_notification_push_supplier: unexpected error", (Throwable)exception);
            throw new UNKNOWN();
        }
    }

    private AbstractProxy obtain_notification_push_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier abstractProxySupplier = this.newProxyPushSupplier(clientType);
        this.configureMappingFilters(abstractProxySupplier);
        this.configureQoS(abstractProxySupplier);
        this.configureInterFilterGroupOperator(abstractProxySupplier);
        this.addProxyToMap(abstractProxySupplier, this.pushServants_, this.modifyProxiesLock_);
        return abstractProxySupplier;
    }

    public ProxyPullSupplier obtain_pull_supplier() {
        try {
            MutablePicoContainer mutablePicoContainer = this.newContainerForEventStyleProxy();
            mutablePicoContainer.registerComponentImplementation(AbstractProxy.class, ECProxyPullSupplierImpl.class);
            AbstractProxy abstractProxy = (AbstractProxy)mutablePicoContainer.getComponentInstanceOfType(AbstractProxy.class);
            this.configureQoS(abstractProxy);
            this.addProxyToMap(abstractProxy, this.pullServants_, this.modifyProxiesLock_);
            return ProxyPullSupplierHelper.narrow(abstractProxy.activate());
        }
        catch (Exception exception) {
            this.logger_.fatalError("obtain_pull_supplier: exception", (Throwable)exception);
            throw new UNKNOWN();
        }
    }

    public ProxyPushSupplier obtain_push_supplier() {
        try {
            MutablePicoContainer mutablePicoContainer = this.newContainerForEventStyleProxy();
            mutablePicoContainer.registerComponentImplementation(AbstractProxy.class, ECProxyPushSupplierImpl.class);
            AbstractProxy abstractProxy = (AbstractProxy)mutablePicoContainer.getComponentInstanceOfType(AbstractProxy.class);
            this.configureQoS(abstractProxy);
            this.addProxyToMap(abstractProxy, this.pushServants_, this.modifyProxiesLock_);
            return ProxyPushSupplierHelper.narrow(abstractProxy.activate());
        }
        catch (Exception exception) {
            this.logger_.fatalError("obtain_push_supplier: exception", (Throwable)exception);
            throw new UNKNOWN(exception.getMessage());
        }
    }

    public List getSubsequentFilterStages() {
        return this.listManager_.getList();
    }

    public MessageConsumer getMessageConsumer() {
        return null;
    }

    public boolean hasMessageConsumer() {
        return false;
    }

    public void actionProxyCreationRequest(ProxyEvent proxyEvent) {
    }

    public void actionProxyDisposed(ProxyEvent proxyEvent) {
        this.listManager_.actionSourceModified();
        this.listManager_.refresh();
    }

    public void actionProxyCreated(ProxyEvent proxyEvent) {
        this.listManager_.actionSourceModified();
    }

    AbstractProxySupplier newProxyPullSupplier(ClientType clientType) {
        Class clazz;
        MutablePicoContainer mutablePicoContainer = this.newContainerForNotifyStyleProxy();
        switch (clientType.value()) {
            case 0: {
                clazz = ProxyPullSupplierImpl.class;
                break;
            }
            case 1: {
                clazz = StructuredProxyPullSupplierImpl.class;
                break;
            }
            case 2: {
                clazz = SequenceProxyPullSupplierImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM();
            }
        }
        mutablePicoContainer.registerComponentImplementation(AbstractProxySupplier.class, clazz);
        AbstractProxySupplier abstractProxySupplier = (AbstractProxySupplier)mutablePicoContainer.getComponentInstanceOfType(AbstractProxySupplier.class);
        return abstractProxySupplier;
    }

    AbstractProxySupplier newProxyPushSupplier(ClientType clientType) {
        Class clazz;
        switch (clientType.value()) {
            case 0: {
                clazz = ProxyPushSupplierImpl.class;
                break;
            }
            case 1: {
                clazz = StructuredProxyPushSupplierImpl.class;
                break;
            }
            case 2: {
                clazz = SequenceProxyPushSupplierImpl.class;
                break;
            }
            default: {
                throw new BAD_PARAM("The ClientType: " + clientType.value() + " is unknown");
            }
        }
        MutablePicoContainer mutablePicoContainer = this.newContainerForNotifyStyleProxy();
        mutablePicoContainer.registerComponentImplementation(AbstractProxySupplier.class, clazz);
        AbstractProxySupplier abstractProxySupplier = (AbstractProxySupplier)mutablePicoContainer.getComponentInstanceOfType(AbstractProxySupplier.class);
        return abstractProxySupplier;
    }

    public String getMBeanType() {
        return "ConsumerAdmin";
    }

    private static final class FilterstageWithMessageConsumerComparator
    implements Comparator {
        private FilterstageWithMessageConsumerComparator() {
        }

        public int compare(Object object, Object object2) {
            FilterStage filterStage = (FilterStage)object;
            FilterStage filterStage2 = (FilterStage)object2;
            return filterStage.getMessageConsumer().compareTo(filterStage2.getMessageConsumer());
        }
    }
}

