/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.config.LoggerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.util.ObjectUtil;

public class JacORBConfiguration
extends DefaultConfiguration
implements Configuration {
    private static final String fileSuffix = ".properties";
    private static final String COMMON_PROPS = "orb.properties";
    private static final String TRUE = "true";
    private static final String ON = "on";
    private static final String EMPTY_STR = "";
    private static final int DEFAULT_LOG_LEVEL = 0;
    private ORB orb = null;
    private Logger logger = null;
    private LoggerFactory loggerFactory = null;
    private final String loggerFactoryClzName = "org.jacorb.config.LogKitLoggerFactory";

    public static Configuration getConfiguration(Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        String string;
        String string2;
        String string3 = "jacorb";
        String string4 = string2 = bl ? null : System.getProperty("ORBid");
        if (properties != null && (string = (String)properties.get("ORBid")) != null) {
            string2 = string;
        }
        if (string2 != null) {
            if (string2.equals("orb") || string2.equals("jacorb")) {
                throw new ConfigurationException("Illegal orbID, <" + string2 + "> is reserved");
            }
            string3 = string2;
        }
        return new JacORBConfiguration(string3, properties, oRB, bl);
    }

    private JacORBConfiguration(String string, Properties properties, ORB oRB, boolean bl) throws ConfigurationException {
        super(string);
        this.orb = oRB;
        if (bl) {
            this.initApplet(string, properties);
        } else {
            this.init(string, properties);
        }
        this.initLogging();
    }

    private void init(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        String string3 = System.getProperty("file.separator");
        String string4 = System.getProperty("user.home");
        String string5 = System.getProperty("java.home");
        boolean bl = false;
        this.setAttributes(System.getProperties());
        int n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
        Properties properties2 = JacORBConfiguration.loadPropertiesFromFile(string5 + string3 + "lib" + string3 + COMMON_PROPS);
        if (properties2 != null) {
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            bl = true;
            if (n > 2) {
                System.out.println("[ base configuration loaded from file " + string5 + string3 + "lib" + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromFile(string4 + string3 + COMMON_PROPS)) != null) {
            this.setAttributes(properties2);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ base configuration loaded from file " + string4 + string3 + COMMON_PROPS + " ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS)) != null) {
            bl = true;
            this.setAttributes(properties2);
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((string2 = this.getAttribute("jacorb.config.dir", EMPTY_STR)).length() == 0) {
            string2 = this.getAttribute("jacorb.home", EMPTY_STR);
        }
        if (string2.length() != 0) {
            string2 = string2 + string3 + "etc";
        } else {
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 0) {
                System.err.println("[ jacorb.home unset! Will use '.' ]");
            }
            string2 = ".";
        }
        String string6 = string2 + string3 + string + fileSuffix;
        Properties properties3 = JacORBConfiguration.loadPropertiesFromFile(string6);
        if (properties3 != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ configuration " + string + " loaded from file " + string6 + " ]");
            }
        } else {
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 0) {
                System.err.println("[ File " + string6 + " for configuration " + string + " not found ]");
            }
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            for (String string7 : list) {
                Properties properties4 = JacORBConfiguration.loadPropertiesFromFile(string7);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
                    if (n <= 2) continue;
                    System.out.println("[ custom properties loaded from file " + string7 + " ]");
                    continue;
                }
                if (n <= 0) continue;
                System.err.println("[ custom properties not found in " + string7 + " ]");
            }
        }
        if ((properties3 = JacORBConfiguration.loadPropertiesFromClassPath(string + fileSuffix)) != null) {
            this.setAttributes(properties3);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ configuration " + string + " loaded from classpath]");
            }
        }
        this.setAttributes(System.getProperties());
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            System.out.println("[ No configuration properties found for configuration " + string + " ]");
        }
    }

    private void initApplet(String string, Properties properties) throws ConfigurationException {
        List list;
        String string2;
        Properties properties2;
        if (string == null) {
            throw new ConfigurationException("Illegal null value for ORB name!");
        }
        boolean bl = false;
        this.setAttributes(properties);
        int n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
        Properties properties3 = JacORBConfiguration.loadPropertiesFromClassPath(COMMON_PROPS);
        if (properties3 != null) {
            bl = true;
            this.setAttributes(properties3);
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ base configuration loaded from classpath orb.properties ]");
            }
        }
        if ((properties2 = JacORBConfiguration.loadPropertiesFromClassPath(string2 = string + fileSuffix)) != null) {
            this.setAttributes(properties2);
            bl = true;
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 2) {
                System.out.println("[ configuration " + string + " loaded from classpath " + string2 + " ]");
            }
        } else {
            n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
            if (n > 0) {
                System.err.println("[ File " + string2 + " for configuration " + string + " not found in classpath]");
            }
        }
        if (!(list = this.getAttributeList("custom.props")).isEmpty()) {
            for (String string3 : list) {
                Properties properties4 = JacORBConfiguration.loadPropertiesFromClassPath(string3);
                if (properties4 != null) {
                    this.setAttributes(properties4);
                    bl = true;
                    n = this.getAttributeAsInteger("jacorb.config.log.verbosity", 0);
                    if (n <= 2) continue;
                    System.out.println("[ custom properties loaded from classpath " + string3 + " ]");
                    continue;
                }
                if (n <= 0) continue;
                System.err.println("[ custom properties " + string3 + "not found in classpath ]");
            }
        }
        if (properties != null) {
            bl = true;
            this.setAttributes(properties);
        }
        if (!bl) {
            System.out.println("[ No configuration properties found for configuration " + string + " ]");
        }
    }

    void setAttributes(Properties properties) {
        for (Object object : properties.keySet()) {
            String string;
            Object object2;
            if (!(object instanceof String) || !((object2 = properties.get(string = (String)object)) instanceof String) && object2 != null) continue;
            this.setAttribute(string, (String)object2);
        }
    }

    private static Properties loadPropertiesFromFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            return properties;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            System.out.println("could not read config file: " + string);
            iOException.printStackTrace();
            return null;
        }
    }

    private static Properties loadPropertiesFromClassPath(String string) {
        Properties properties = null;
        try {
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
            if (uRL != null) {
                properties = new Properties();
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.out.println("could not read config file: " + string);
            iOException.printStackTrace();
        }
        return properties;
    }

    private void initLogging() {
        String string = this.getAttribute("jacorb.logfile", EMPTY_STR);
        int n = this.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0);
        if (!string.equals(EMPTY_STR) && string.endsWith("$implname")) {
            string = string.substring(0, string.length() - 9);
            string = !this.getAttribute("jacorb.implname", EMPTY_STR).equals(EMPTY_STR) ? string + this.getAttribute("jacorb.implname", EMPTY_STR) : string + "log";
        }
        String string2 = this.getAttribute("jacorb.log.loggerFactory", EMPTY_STR);
        Class clazz = null;
        try {
            clazz = !string2.equals(EMPTY_STR) ? ObjectUtil.classForName(string2) : ObjectUtil.classForName("org.jacorb.config.LogKitLoggerFactory");
            this.loggerFactory = (LoggerFactory)clazz.newInstance();
            this.loggerFactory.configure(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.loggerFactory == null) {
            System.err.println("Configuration Error, could not create logger!");
        }
        if (!string.equals(EMPTY_STR)) {
            try {
                this.loggerFactory.setDefaultLogFile(string, n);
                this.logger = this.loggerFactory.getNamedLogger("jacorb", string, n);
            }
            catch (IOException iOException) {
                this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create logger with file target: " + string + ", falling back to console log!");
                }
            }
        } else {
            this.logger = this.loggerFactory.getNamedRootLogger("jacorb");
        }
    }

    public ORB getORB() {
        return this.orb;
    }

    public Logger getNamedLogger(String string) {
        return this.loggerFactory.getNamedLogger(string);
    }

    public String getLoggerName(Class clazz) {
        String string = clazz.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2 != null && string2.startsWith("org.jacorb")) {
            return string2.substring(4);
        }
        return string2;
    }

    public List getAttributeList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.getAttribute(string);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public Object getAttributeAsObject(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string, null);
        if (string2 != null && string2.length() > 0) {
            try {
                Class clazz = ObjectUtil.classForName(string2);
                return clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ConfigurationException("Unable to build class from key >" + string + "<: " + exception);
            }
        }
        return null;
    }

    public boolean getAttributeAsBoolean(String string) throws ConfigurationException {
        String string2 = this.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return false;
    }

    public boolean getAttributeAsBoolean(String string, boolean bl) {
        String string2 = this.getAttribute(string, EMPTY_STR);
        if (string2.length() > 0) {
            return ON.equals(string2 = string2.trim().toLowerCase()) || TRUE.equals(string2);
        }
        return bl;
    }
}

